/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface.apps;

import java.awt.Choice;
import java.awt.Component;
import java.util.Vector;
import rvl.piface.PiArrayField;
import rvl.piface.PiChoice;
import rvl.piface.PiListener;
import rvl.piface.Piface;
import rvl.piface.apps.AnovaGUI;
import rvl.stat.anova.Factor;
import rvl.stat.anova.Model;
import rvl.stat.anova.Residual;
import rvl.stat.anova.Term;
import rvl.stat.anova.WithinCells;
import rvl.stat.dist.F;
import rvl.stat.dist.T;
import rvl.stat.dist.Tukey;
import rvl.util.Closeable;
import rvl.util.Utility;

public class AnovaCompGUI
extends Piface
implements PiListener {
    private static String title = "ANOVA Comparisons";
    public double effSize;
    public double[] n;
    public double[] effSD;
    public double power;
    public double alpha;
    public double famSize;
    public double bonfDiv;
    public double[] coef;
    public int comp;
    public int cvType;
    public int autoBonf;
    public int restr;
    public int oneSided;
    public PiArrayField coefFld;
    protected String[] restrStg;
    protected String[] cvStg;
    protected String[] fixedNames;
    protected Model model;
    protected Term[] fixedTerms;
    protected Vector restrVec;
    protected AnovaGUI ag;
    protected boolean ignoreActions = false;
    private int bonfIndex;
    private Component bonfComp;
    private Component famComp;
    private Component restrComp;
    private double[] vdf;
    private double cv;
    static /* synthetic */ Class class$rvl$piface$apps$AnovaGUI;

    public void gui() {
        Term term;
        int n;
        this.label("Levels / Sample size");
        this.beginSubpanel(1, false);
        for (n = 0; n < this.model.nFac(); ++n) {
            term = this.model.getFac(n);
            String string = ((Factor)term).isRandom() ? "n[" : "levels[";
            String string2 = string + ((Factor)term).getName() + "]";
            if (string2.equals("n[Residual]")) {
                string2 = "Replications";
            }
            this.bar("n[" + n + "]", string2, (double)((Factor)term).getLevels());
        }
        this.endSubpanel();
        this.newColumn();
        this.label("Random effects");
        this.beginSubpanel(1, false);
        for (n = 0; n < this.model.nTerm(); ++n) {
            term = this.model.getTerm(n);
            if (!term.isRandom()) continue;
            this.bar("effSD[" + n + "]", "SD[" + term.getName() + "]", this.effSD[n]);
        }
        this.endSubpanel();
        this.newColumn();
        this.label("Contrasts across fixed levels");
        this.beginSubpanel(1, false);
        this.choice("comp", "Contrast levels of", this.fixedNames, 0);
        this.coefFld = this.arrayField("click", "Contrast coefficients", new double[]{-1.0, 1.0});
        this.choice("restr", "Restriction", this.restrStg, 0);
        this.beginSubpanel(2);
        this.choice("cvType", "Method", this.cvStg, 2);
        this.field("famSize", "# means", 1.0, 2, 3);
        this.choice("alpha", "Alpha ", new double[]{0.005, 0.01, 0.02, 0.05, 0.1, 0.2}, 3);
        this.field("bonfDiv", "# tests", 1.0, 2, 3);
        this.checkbox("oneSided", "One-Sided", 0);
        this.endSubpanel();
        this.beginSubpanel(1, true);
        this.bar("effSize", "Detectable contrast", 1.0);
        this.ointerval("power", "Power", 0.0, 0.0, 1.0);
        this.endSubpanel();
        this.endSubpanel();
        this.bonfComp = (Component)((Object)this.getComponent("bonfDiv"));
        this.bonfComp.setVisible(false);
        this.famComp = (Component)((Object)this.getComponent("famSize"));
        this.restrComp = (Component)((Object)this.getComponent("restr"));
        this.restrComp.setVisible(false);
        this.menuCheckbox("autoBonf", "Auto Bonferroni", 1);
        this.menuItem("linkAOV", "ANOVA dialog");
        this.menuItem("showEMS", "Show EMS");
        this.menuItem("report", "Report");
        this.menuItem("help", "ANOVA contrasts help", this.helpMenu);
    }

    public void beforeSetup() {
        int n;
        int n2;
        this.n = new double[this.model.nFac()];
        if (this.effSD == null) {
            this.effSD = new double[this.model.nTerm()];
            for (n2 = 0; n2 < this.model.nTerm(); ++n2) {
                this.effSD[n2] = 1.0;
            }
        }
        n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.model.nTerm(); ++n) {
            if (this.model.getTerm(n).isRandom()) continue;
            ++n2;
        }
        if (n2 == 0) {
            Utility.error("There are no fixed factors, so no contrasts can be studied", (Closeable)this);
            return;
        }
        this.fixedNames = new String[n2];
        this.fixedTerms = new Term[n2];
        for (n = 0; n < this.model.nTerm(); ++n) {
            if (this.model.getTerm(n).isRandom()) continue;
            this.fixedTerms[n3] = this.model.getTerm(n);
            this.fixedNames[n3] = this.fixedTerms[n3].getName();
            ++n3;
        }
        this.restrStg = new String[]{"(no restrictions)"};
        this.restrVec = this.model.getAllCompRestr(this.fixedTerms[0]);
        this.cvStg = new String[]{"t", "Dunnett", "Tukey/HSD", "Bonferroni", "Scheffe"};
        this.bonfIndex = 3;
    }

    public void afterSetup() {
        this.setFamSize();
        this.click();
        this.updateVars();
    }

    public void click() {
        this.bonfDiv = Piface.max(1.0, Piface.round(this.bonfDiv));
        Factor[] factorArray = (Factor[])this.restrVec.elementAt(this.restr);
        Term term = this.fixedTerms[this.comp];
        this.vdf = this.model.getCompVariance(term, factorArray, this.effSD);
        double d = this.vdf[0];
        double d2 = this.vdf[1];
        double[] dArray = this.coefFld.getValue();
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < Piface.min(term.span(), dArray.length); ++i) {
            d3 += dArray[i];
            d4 += dArray[i] * dArray[i];
        }
        if (Piface.abs(d3) > 0.001 || d4 < 0.001) {
            this.power = Double.NaN;
            return;
        }
        double d5 = this.effSize / Piface.sqrt(d4 * d);
        double d6 = 2.0 - (double)this.oneSided;
        switch (this.cvType) {
            case 0: {
                this.cv = -T.quantile(this.alpha / d6, d2);
                break;
            }
            case 1: {
                this.cv = -T.quantile(this.alpha / (d6 * (this.famSize - 1.0)), d2);
                break;
            }
            case 2: {
                this.cv = Tukey.quantile(1.0 - 2.0 * this.alpha / d6, this.famSize, d2) / Piface.sqrt(2.0);
                break;
            }
            case 3: {
                this.cv = -T.quantile(this.alpha / (d6 * this.bonfDiv), d2);
                break;
            }
            case 4: {
                this.cv = Piface.sqrt((this.famSize - 1.0) * F.quantile(1.0 - 2.0 * this.alpha / d6, this.famSize - 1.0, d2));
            }
        }
        this.famComp.setVisible(this.cvType > 0);
        this.power = 1.0 - T.cdf(this.cv, d2, d5);
        if (this.oneSided == 0) {
            this.power += T.cdf(-this.cv, d2, d5);
        }
    }

    public void cvType_changed() {
        this.bonfComp.setVisible(this.cvType == this.bonfIndex);
        if (this.cvType == this.bonfIndex) {
            this.show();
            this.setBonf();
        }
        this.click();
    }

    public void n_changed() {
        this.model.recalcLU = true;
        this.n[this.sourceIndex] = Piface.max(1.0, Piface.round(this.n[this.sourceIndex]));
        Factor factor = this.model.getFac(this.sourceIndex);
        factor.setLevels((int)this.n[this.sourceIndex]);
        for (int i = 0; i < this.model.nFac(); ++i) {
            this.n[i] = this.model.getFac(i).getLevels();
        }
        if (!factor.isRandom()) {
            this.restr_changed();
        }
        this.click();
    }

    public void comp_changed() {
        this.restrVec = this.model.getAllCompRestr(this.fixedTerms[this.comp]);
        Choice choice = ((PiChoice)this.restrComp).getChoice();
        choice.removeAll();
        choice.add("(no restrictions)");
        this.restr = 0;
        if (this.restrVec.size() < 2) {
            this.restrComp.setVisible(false);
        } else {
            this.restrComp.setVisible(true);
            for (int i = 1; i < this.restrVec.size(); ++i) {
                Factor[] factorArray = (Factor[])this.restrVec.elementAt(i);
                String string = "Same ";
                for (int j = 0; j < factorArray.length; ++j) {
                    if (j > 0) {
                        string = string + " and ";
                    }
                    string = string + factorArray[j].getShortName();
                }
                choice.add(string);
            }
        }
        this.setFamSize();
        this.setBonf();
        this.click();
    }

    public void restr_changed() {
        this.setFamSize();
        if (this.autoBonf == 1) {
            this.setBonf();
        }
        this.click();
    }

    public void autoBonf_changed() {
        this.restr_changed();
    }

    public void setBonf() {
        this.bonfDiv = this.famSize > 1.0 ? this.famSize * (this.famSize - 1.0) / 2.0 : 1.0;
    }

    public void setFamSize() {
        Factor[] factorArray;
        this.famSize = this.fixedTerms[this.comp].span();
        if (this.restr > 0 && (factorArray = (Factor[])this.restrVec.elementAt(this.restr)) != null) {
            for (int i = 0; i < factorArray.length; ++i) {
                this.famSize /= (double)factorArray[i].getLevels();
            }
        }
    }

    public synchronized void restoreVars(double[] dArray) {
        super.restoreVars(dArray);
        for (int i = 0; i < this.model.nFac(); ++i) {
            this.model.getFac(i).setLevels((int)this.n[i]);
        }
    }

    public void linkAOV() {
        this.ag = new AnovaGUI(this.getTitle(), this.model, this.effSD);
        this.addPiListener(this.ag);
        this.ag.addPiListener(this);
        this.ag.acg = this;
    }

    public synchronized void piAction(String string) {
        if (this.ignoreActions || this.ag == null) {
            return;
        }
        this.setVar(string, this.ag);
        this.callMethodFor(string);
        this.updateVars();
        this.ag.ignoreActions = true;
        this.notifyListeners(string);
        this.ag.ignoreActions = false;
    }

    public void close() {
        if (this.ag != null) {
            this.removePiListener(this.ag);
            this.ag.removePiListener(this);
            this.ag.acg = null;
        }
        this.dispose();
    }

    public void showEMS() {
        this.showText(this.model.EMSString(), "Expected mean squares", 25, 50);
    }

    public void report() {
        Term term = this.fixedTerms[this.comp];
        StringBuffer stringBuffer = new StringBuffer("Power analysis of comparisons/contrasts\n");
        stringBuffer.append("\nModel:\n");
        for (int i = 0; i < this.model.nTerm(); ++i) {
            int n;
            Term term2 = this.model.getTerm(i);
            stringBuffer.append("  " + Utility.format(term2.getName(), 20));
            int n2 = n = term2 instanceof Factor ? ((Factor)term2).getLevels() : term2.span();
            if (term2.isRandom()) {
                stringBuffer.append(" \trandom \t " + n + " levels \tSD = " + this.effSD[i] + "\n");
                continue;
            }
            stringBuffer.append(" \tfixed \t " + n + " levels\n");
        }
        stringBuffer.append("\nContrast of means at levels of " + this.fixedNames[this.comp] + "\n");
        stringBuffer.append("Contrast coefficients: ");
        double[] dArray = this.coefFld.getValue();
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            stringBuffer.append(Utility.format(dArray[i], 3) + " ");
            d += dArray[i] * dArray[i];
        }
        String string = Utility.format(d, 3);
        stringBuffer.append("\nEffect size of interest = " + Utility.format(this.effSize, 3) + "\n");
        stringBuffer.append("Critical value: " + this.cvStg[this.cvType] + "\n");
        stringBuffer.append("Powers are computed for " + (2 - this.oneSided) + "-sided tests with alpha = " + this.alpha + ".\n");
        double[] dArray2 = this.saveVars();
        this.restr = 0;
        while (this.restr < this.restrVec.size()) {
            Factor[] factorArray = (Factor[])this.restrVec.elementAt(this.restr);
            if (this.restr == 0) {
                stringBuffer.append("\nNo restrictions");
            } else {
                stringBuffer.append("\nSame ");
                for (int i = 0; i < factorArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(" and ");
                    }
                    stringBuffer.append(factorArray[i].getShortName());
                }
            }
            this.restr_changed();
            this.click();
            stringBuffer.append("  (" + (int)this.famSize + " means");
            if (this.cvType == this.bonfIndex) {
                stringBuffer.append(", " + (int)this.bonfDiv + " tests");
            }
            stringBuffer.append(")\n");
            String[] stringArray = this.model.getCompVarString(term, factorArray);
            double d2 = Piface.sqrt(d * this.vdf[0]);
            stringBuffer.append("  Variance = " + string + " * [" + stringArray[0] + "]\n");
            stringBuffer.append("  Estimator = " + string + " * [" + stringArray[1] + "]\n");
            stringBuffer.append("  SE = " + Utility.fixedFormat(d2, 4));
            stringBuffer.append("    LSC = " + Utility.fixedFormat(this.cv * d2, 4));
            stringBuffer.append("    d.f. = " + Utility.fixedFormat(this.vdf[1], 1));
            stringBuffer.append("    Power = " + Utility.format(this.power, 4) + "\n");
            ++this.restr;
        }
        stringBuffer.append("\n(\"LSC\" = \"Least significant contrast\")\n");
        this.restoreVars(dArray2);
        this.showText(stringBuffer.toString(), "Power analysis of comparisons/contrasts", 25, 60);
    }

    public void help() {
        this.showText(class$rvl$piface$apps$AnovaGUI == null ? (class$rvl$piface$apps$AnovaGUI = AnovaCompGUI.class$("rvl.piface.apps.AnovaGUI")) : class$rvl$piface$apps$AnovaGUI, "AnovaCompHelp.txt", "Help for contrasts power analysis", 25, 60);
    }

    public AnovaCompGUI(String string, String string2, int n, String string3, String string4) {
        super(string, false);
        this.model = new Model(string2);
        if (n <= 1) {
            this.model.addTerm(new Residual(this.model));
        } else {
            this.model.addFactor(new WithinCells(this.model, n));
        }
        if (string3 != null) {
            this.model.setLevels(string3);
        }
        if (string4 != null) {
            this.model.setRandom(string4);
        }
        this.build();
    }

    public AnovaCompGUI(String string, Model model, double[] dArray) {
        super(string, false);
        this.model = model;
        this.effSD = dArray;
        this.build();
    }

    public static void main(String[] stringArray) {
        new AnovaCompGUI("Nested-factorial model", "grp + Subj(grp) + trt + grp*trt", 2, "grp 4   Subj 5   trt 3", "Subj");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

