/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.rosuda.JRI.Rengine;
import org.rosuda.REngine.JRI.JRIEngine;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPReference;
import org.rosuda.REngine.REngine;
import rvl.piface.PiListener;
import rvl.piface.Piface;

public class PifaceRengine
extends Piface {
    private static String title = "";
    protected REngine rengine;
    protected REXP renviron = null;
    public HashMap<String, REXP> actionMap = new HashMap();

    public PifaceRengine(String string, REXPReference rEXPReference) {
        super(string, false);
        this.findEngine();
        this.renviron = rEXPReference.resolve();
        try {
            this.rengine.assign(".PifaceEnv", this.renviron, this.renviron);
        }
        catch (Exception exception) {
            this.errmsg("Failed to initialize environment");
        }
        this.newColumn();
    }

    public PifaceRengine(String string, boolean bl) {
        super(string, false);
        this.findEngine();
        this.renviron = null;
        if (bl && this.rengine.supportsReferences()) {
            try {
                this.renviron = this.rengine.newEnvironment(this.rengine.get(".GlobalEnv", null, true), false);
                this.rengine.assign(".PifaceEnv", this.renviron, this.renviron);
            }
            catch (Exception exception) {
                this.errmsg("Failed to create a new environment");
            }
        }
        this.newColumn();
    }

    private void findEngine() {
        this.rengine = REngine.getLastEngine();
        if (this.rengine == null) {
            try {
                this.rengine = new JRIEngine(Rengine.getMainEngine());
            }
            catch (Exception exception) {
                System.err.println("Unable to get a running REngine");
                return;
            }
        }
    }

    public PifaceRengine(String string) {
        this(string, true);
    }

    @Override
    public void gui() {
    }

    @Override
    protected void afterSetup() {
        int n = this.optMenu.getItemCount() - 6;
        this.optMenu.remove(3 + n);
        this.optMenu.remove(2 + n);
        this.optMenu.remove(1 + n);
    }

    @Override
    public void click() {
    }

    @Override
    public void close() {
        Enumeration enumeration = ((Vector)this.listeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            PiListener piListener = (PiListener)enumeration.nextElement();
            piListener.close();
        }
        this.dispose();
    }

    @Override
    public void errmsg(String string, String string2, boolean bl) {
        String string3 = string2 == null ? string : string + ": " + string2;
        try {
            if (bl) {
                this.rengine.parseAndEval("stop(\"" + string3 + "\")", this.renviron, true);
            } else {
                this.rengine.parseAndEval("warning(\"" + string3 + "\")", this.renviron, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void stackTrace(Throwable throwable) {
        this.errmsg("Stack trace", throwable.toString(), true);
    }

    public void setHandler(String string, String string2) {
        String string3 = this.renviron == null ? string2 + "()" : string2 + "(.PifaceEnv)";
        try {
            REXP rEXP = this.rengine.parse(string3, false);
            this.actionMap.put(string, rEXP);
        }
        catch (Exception exception) {
            this.errmsg("Error in registering event handler " + string3 + " for " + string + "; Syntax error?");
        }
    }

    @Override
    public void callMethodFor(String string) {
        this.actionSource = string;
        this.sourceIndex = -1;
        REXP rEXP = this.actionMap.get(this.actionSource);
        if (rEXP == null) {
            rEXP = this.actionMap.get("default");
        }
        if (rEXP == null) {
            return;
        }
        try {
            this.rengine.eval(rEXP, this.renviron, true);
        }
        catch (Exception exception) {
            System.err.println("Problem in handling action for " + string);
        }
    }

    @Override
    public void callMethod(String string) {
        if (string.equals("guiHelp") || string.equals("aboutPiface")) {
            super.callMethod(string);
        } else {
            this.callMethodFor(string);
        }
    }

    @Override
    protected void setVar(String string, double d) {
        if (string.endsWith("]")) {
            this.setVar(this.parseArray(string), d);
            return;
        }
        try {
            this.rengine.assign(string, (REXP)new REXPDouble(d), this.renviron);
        }
        catch (Exception exception) {
            this.errmsg("Cannot set double variable " + string);
            this.stackTrace(exception);
        }
    }

    @Override
    protected double getDVar(String string) {
        try {
            REXP rEXP = this.rengine.get(string, this.renviron, true);
            if (rEXP != null) {
                return rEXP.asDouble();
            }
            return Double.NaN;
        }
        catch (Exception exception) {
            this.errmsg("Cannot get double variable " + string);
            this.stackTrace(exception);
            return Double.NaN;
        }
    }

    @Override
    protected void setVar(Object[] objectArray, double d) {
        int n = (Integer)objectArray[1] + 1;
        String string = "" + objectArray[0] + "[" + n + "] <- " + d;
        try {
            this.rengine.parseAndEval(string, this.renviron, true);
        }
        catch (Exception exception) {
            this.errmsg("Cannot evaluate " + string);
            this.stackTrace(exception);
        }
    }

    @Override
    protected double getDVar(Object[] objectArray) {
        int n = (Integer)objectArray[1] + 1;
        String string = "" + objectArray[0] + "[" + n + "]";
        try {
            REXP rEXP = this.rengine.parseAndEval(string, this.renviron, true);
            if (rEXP != null) {
                return rEXP.asDouble();
            }
            return Double.NaN;
        }
        catch (Exception exception) {
            this.errmsg("Cannot get double variable " + string);
            this.stackTrace(exception);
            return Double.NaN;
        }
    }

    @Override
    protected void setVar(String string, int n) {
        if (string.endsWith("]")) {
            this.setVar(this.parseArray(string), n);
            return;
        }
        try {
            this.rengine.assign(string, (REXP)new REXPInteger(n), this.renviron);
        }
        catch (Exception exception) {
            this.errmsg("Cannot set int variable " + string);
            this.stackTrace(exception);
        }
    }

    @Override
    protected int getIVar(String string) {
        try {
            REXP rEXP = this.rengine.parseAndEval(string, this.renviron, true);
            if (rEXP != null) {
                return rEXP.asInteger();
            }
            return -9999;
        }
        catch (Exception exception) {
            this.errmsg("Cannot get int variable " + string);
            this.stackTrace(exception);
            return -9999;
        }
    }

    @Override
    protected void setVar(Object[] objectArray, int n) {
        int n2 = (Integer)objectArray[1] + 1;
        String string = "" + objectArray[0] + "[" + n2 + "] <- as.integer(" + n + ")";
        try {
            this.rengine.parseAndEval(string, this.renviron, true);
        }
        catch (Exception exception) {
            this.errmsg("Cannot evaluate " + string);
            this.stackTrace(exception);
        }
    }

    @Override
    protected int getIVar(Object[] objectArray) {
        int n = (Integer)objectArray[1] + 1;
        String string = "" + objectArray[0] + "[" + n + "]";
        try {
            REXP rEXP = this.rengine.parseAndEval(string, this.renviron, true);
            if (rEXP != null) {
                return rEXP.asInteger();
            }
            return -9999;
        }
        catch (Exception exception) {
            this.errmsg("Cannot get int variable " + string);
            this.stackTrace(exception);
            return -9999;
        }
    }

    public REXP getEnviron() {
        return this.renviron;
    }

    public void saveEnviron(String string) {
        try {
            this.rengine.assign(string, this.renviron, null);
        }
        catch (Exception exception) {
            this.errmsg("Unable to save environment in R");
        }
    }

    public void refresh() {
        this.callMethodFor("default");
        this.updateVars();
    }
}

