/*
 * Decompiled with CFR 0.152.
 */
package rvl.awt;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class ViewWindow
extends Frame
implements ActionListener,
AdjustmentListener {
    public TextArea ta;
    private Scrollbar fontSB;
    private Label fontLab = new Label("12 pt    ");
    private int fontSize = 12;
    private Button clearButton;

    public ViewWindow(String string, int n, int n2) {
        this.setTitle(string);
        this.setLayout(new BorderLayout());
        this.ta = new TextArea(n, n2);
        this.ta.setEditable(false);
        this.ta.setFont(new Font("Courier", 0, this.fontSize));
        Panel panel = new Panel();
        panel.setBackground(Color.lightGray);
        panel.setLayout(new FlowLayout());
        this.fontSB = new Scrollbar(0, this.fontSize, 1, 6, 19);
        this.clearButton = new Button("Clear");
        this.clearButton.setVisible(false);
        Button button = new Button("Close");
        panel.add(new Label("Font size"));
        panel.add(this.fontSB);
        panel.add(this.fontLab);
        panel.add(this.clearButton);
        panel.add(button);
        button.addActionListener(this);
        this.fontSB.addAdjustmentListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ViewWindow.this.dispose();
            }
        });
        this.add("Center", this.ta);
        this.add("South", panel);
        this.pack();
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Close")) {
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Clear")) {
            this.ta.setText("");
        }
    }

    public void setClearButton(boolean bl) {
        if (bl) {
            this.clearButton.addActionListener(this);
            this.clearButton.setVisible(true);
            this.show();
        } else {
            this.clearButton.removeActionListener(this);
            this.clearButton.setVisible(false);
            this.show();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource().equals(this.fontSB)) {
            this.fontSize = adjustmentEvent.getValue();
            this.fontLab.setText(this.fontSize + " pt    ");
            this.ta.setFont(new Font("Courier", 0, this.fontSize));
        }
    }

    public void append(String string) {
        this.ta.append(string);
    }

    public void setText(String string) {
        this.ta.setText(string);
    }

    public String getText() {
        return this.ta.getText();
    }

    public void setTop() {
        this.ta.setCaretPosition(0);
    }
}

