/*
 * Decompiled with CFR 0.152.
 */
package rvl.awt;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import rvl.awt.GridLine;
import rvl.awt.RVLayout;

public class GPDialog
extends Dialog
implements ActionListener {
    protected Component[] component;
    protected int cols = 30;
    protected int rows = 4;
    protected boolean ok = false;

    public GPDialog(Frame frame, String string, String[][] stringArray) {
        super(frame, string, true);
        Component component;
        this.setLayout(new RVLayout(1));
        this.component = new Component[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.add(new Label(stringArray[i][0]));
            if (stringArray[i][1].equals("TextField")) {
                component = new TextField(this.cols);
                this.add(component);
                this.component[i] = component;
                continue;
            }
            component = new TextArea(this.rows, this.cols);
            this.add(component);
            this.component[i] = component;
        }
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        component = new Button("OK");
        Button button = new Button("Cancel");
        panel.add(component);
        panel.add(button);
        ((Button)component).addActionListener(this);
        button.addActionListener(this);
        this.add(panel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GPDialog.this.ok = false;
                GPDialog.this.dispose();
            }
        });
        Point point = frame.getLocation();
        point.x += 50;
        point.y += 50;
        this.setLocation(point);
        this.pack();
    }

    public GPDialog(Frame frame, String string, String[] stringArray, Component[] componentArray, boolean bl) {
        super(frame, string, true);
        Serializable serializable;
        this.setLayout(new RVLayout(1));
        this.component = componentArray;
        for (int i = 0; i < stringArray.length; ++i) {
            this.add(new Label(stringArray[i]));
            this.add(componentArray[i]);
        }
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        Button button = new Button("OK");
        panel.add(button);
        button.addActionListener(this);
        if (bl) {
            serializable = new Button("Cancel");
            serializable.addActionListener(this);
            panel.add((Component)serializable);
        }
        this.add(panel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GPDialog.this.ok = false;
                GPDialog.this.dispose();
            }
        });
        serializable = frame.getLocation();
        ((Point)serializable).x += 50;
        ((Point)serializable).y += 50;
        this.setLocation((Point)serializable);
        this.pack();
    }

    public GPDialog(Frame frame, String string, String[] stringArray, Component[] componentArray) {
        this(frame, string, stringArray, componentArray, true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.ok = true;
        } else if (string.equals("Cancel")) {
            this.ok = false;
        }
        this.dispose();
    }

    public static String[] dialog(Frame frame, String string, String[][] stringArray) {
        if (frame == null) {
            frame = new Frame();
        }
        GPDialog gPDialog = new GPDialog(frame, string, stringArray);
        gPDialog.show();
        if (gPDialog.ok) {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Component component = gPDialog.component[i];
                if (component instanceof TextField) {
                    stringArray2[i] = ((TextField)component).getText();
                    continue;
                }
                if (!(component instanceof TextArea)) continue;
                stringArray2[i] = ((TextArea)component).getText();
            }
            return stringArray2;
        }
        return null;
    }

    public static String[] dialog(Frame frame, String string, String[] stringArray, Component[] componentArray) {
        if (frame == null) {
            frame = new Frame();
        }
        GPDialog gPDialog = new GPDialog(frame, string, stringArray, componentArray);
        gPDialog.show();
        if (componentArray.length > 0) {
            componentArray[0].requestFocus();
        }
        if (gPDialog.ok) {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Component component = gPDialog.component[i];
                stringArray2[i] = component instanceof TextComponent ? ((TextComponent)component).getText() : (String)null;
            }
            return stringArray2;
        }
        return null;
    }

    public static void msgBox(Frame frame, String string, String string2) {
        if (frame == null) {
            frame = new Frame();
        }
        GPDialog gPDialog = new GPDialog(frame, string, new String[]{string2}, new Component[]{new GridLine(0)}, false);
        gPDialog.show();
    }

    public static boolean okCancelDialog(Frame frame, String string, String string2) {
        if (frame == null) {
            frame = new Frame();
        }
        GPDialog gPDialog = new GPDialog(frame, string, new String[]{string2}, new Component[]{new Label("")});
        gPDialog.show();
        return gPDialog.ok;
    }

    public static String stringDialog(Frame frame, String string, String string2, String string3, int n) {
        if (frame == null) {
            frame = new Frame();
        }
        TextField textField = new TextField(string3, n);
        GPDialog gPDialog = new GPDialog(frame, string, new String[]{string2}, new Component[]{textField});
        textField.requestFocus();
        gPDialog.show();
        if (gPDialog.ok) {
            return textField.getText();
        }
        return null;
    }

    public static String stringDialog(Frame frame, String string, String string2) {
        return GPDialog.stringDialog(frame, string, string2, "", 30);
    }

    public static String stringDialog(Frame frame, String string, String string2, String string3) {
        return GPDialog.stringDialog(frame, string, string2, string3, 30);
    }

    public static int intDialog(Frame frame, String string, String string2, String string3) {
        String string4 = GPDialog.stringDialog(frame, string, string2, string3, 5);
        if (string4 == null) {
            return Integer.MIN_VALUE;
        }
        try {
            return new Integer(string4);
        }
        catch (NumberFormatException numberFormatException) {
            GPDialog.msgBox(frame, string, "Invalid integer: " + string4 + " - try again");
            return GPDialog.intDialog(frame, string, string2, string3);
        }
    }

    public static int intDialog(Frame frame, String string, String string2, int n) {
        return GPDialog.intDialog(frame, string, string2, "" + n);
    }

    public static int intDialog(Frame frame, String string, String string2) {
        return GPDialog.intDialog(frame, string, string2, "");
    }

    public static double doubleDialog(Frame frame, String string, String string2, String string3) {
        String string4 = GPDialog.stringDialog(frame, string, string2, string3, 15);
        if (string4 == null) {
            return Double.NaN;
        }
        try {
            return new Double(string4);
        }
        catch (NumberFormatException numberFormatException) {
            GPDialog.msgBox(frame, string, "Invalid number: " + string4 + " - try again");
            return GPDialog.doubleDialog(frame, string, string2, string3);
        }
    }

    public static double doubleDialog(Frame frame, String string, String string2, double d) {
        return GPDialog.doubleDialog(frame, string, string2, "" + d);
    }

    public static double doubleDialog(Frame frame, String string, String string2) {
        return GPDialog.doubleDialog(frame, string, string2, "");
    }
}

