/*
 * Decompiled with CFR 0.152.
 */
package rvl.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import rvl.awt.BarGroup;

public class Bar
extends Canvas {
    private double value;
    private int intVal;
    private BarGroup group;
    private int hotMaxX;
    private int hotMinY;
    private int hotMaxY;
    private Object barID;
    private boolean intMode = false;
    protected transient ActionListener actionListener = null;

    public Bar(Object object, double d, BarGroup barGroup) {
        this.barID = object;
        this.group = barGroup;
        this.value = Double.isNaN(d) ? 0.0 : Math.max(d, 0.0);
        barGroup.addBar(this, d);
    }

    public Bar(Object object, int n, BarGroup barGroup) {
        this.barID = object;
        this.group = barGroup;
        this.intMode = true;
        this.intVal = n;
        this.value = this.intVal;
        barGroup.addBar(this, this.value);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public double getValue() {
        return this.value;
    }

    public int getIntVal() {
        if (this.intMode) {
            return this.intVal;
        }
        return (int)(this.value + 0.5);
    }

    public void setValue(double d) {
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        this.value = Math.max(d, 0.0);
        if (!this.group.rescalable) {
            this.value = Math.min(this.value, this.group.limit);
            this.repaint();
            return;
        }
        if (!this.group.checkValue(this.value)) {
            this.repaint();
        }
    }

    public void setValue(int n) {
        this.intVal = n;
        this.setValue((double)n);
    }

    public Dimension preferredSize() {
        return new Dimension(300, 15);
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public void paint(Graphics graphics) {
        int n = this.size().width - 10;
        int n2 = this.size().height / 2;
        int n3 = n2 - 4;
        int n4 = n2 + 4;
        this.hotMaxX = n + 5;
        this.hotMinY = n2 - 2;
        this.hotMaxY = n2 + 2;
        double d = (double)n / this.group.limit;
        graphics.setColor(this.group.lineColor);
        graphics.drawLine(5, n2, this.hotMaxX, n2);
        graphics.setColor(this.group.tickColor);
        for (double d2 = 0.0; d2 < 1.01 * this.group.limit; d2 += this.group.tickInterval) {
            int n5 = (int)(5.5 + d2 * d);
            graphics.drawLine(n5, n3, n5, n4);
        }
        int n6 = (int)(0.5 + this.value * d);
        graphics.setColor(this.group.barColor);
        graphics.fillRect(5, this.hotMinY, n6, 5);
    }

    private boolean isHot(int n, int n2) {
        return n2 >= this.hotMinY && n2 <= this.hotMaxY && n >= 5 && n <= this.hotMaxX;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        if (this.group.readOnly) {
            this.group.parentFrame.setCursor(0);
        } else {
            this.group.parentFrame.setCursor(1);
        }
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.group.parentFrame.setCursor(0);
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.requestFocus();
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.group.readOnly) {
            return true;
        }
        if (!this.isHot(n, n2)) {
            return true;
        }
        this.value = this.group.limit * (double)(n - 5) / (double)(this.size().width - 10);
        if (this.intMode) {
            this.intVal = new Double(this.value + 0.5).intValue();
            this.value = this.intVal;
        }
        this.repaint();
        if (this.actionListener != null) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, this.barID.toString());
            this.actionListener.actionPerformed(actionEvent);
        } else {
            this.deliverEvent(new Event(this, 1001, this.barID));
        }
        this.group.parentFrame.setCursor(1);
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.group.readOnly) {
            return true;
        }
        int n3 = n < 5 ? 5 : (n > this.hotMaxX ? this.hotMaxX : n);
        this.value = this.group.limit * (double)(n3 - 5) / (double)(this.size().width - 10);
        if (this.intMode) {
            this.intVal = new Double(this.value).intValue();
            this.value = this.intVal;
        }
        this.repaint();
        this.deliverEvent(new Event(this, 1001, this.barID));
        return true;
    }
}

