/*
 * Decompiled with CFR 0.152.
 */
package rvl.stat.dist;

import rvl.stat.dist.Beta;
import rvl.stat.dist.FAux;
import rvl.util.NumAnal;
import rvl.util.Solve;
import rvl.util.Utility;

public class F {
    private static double saveLambda = 0.0;
    private static double saveEffSize = 1.0;
    private static double saveDf1 = 1.0;
    private static double saveDf2 = 1.0;
    private static boolean saveRandom = false;
    static /* synthetic */ Class class$rvl$stat$dist$F;

    public static double cdf(double d, double d2, double d3) {
        if (d2 <= 0.0 || d3 <= 0.0) {
            Utility.warning("F.cdf: must use positive df");
            return Double.NaN;
        }
        return F.cdf(d, d2, d3, 0.0);
    }

    public static double cdf(double d, double d2, double d3, double d4) {
        if (d2 <= 0.0 || d3 <= 0.0 || d4 < 0.0) {
            Utility.warning("F.cdf: must use positive df and lambda");
            return Double.NaN;
        }
        d = Math.max(d, 0.0);
        return Beta.cdf(1.0 - d3 / (d2 * d + d3), d2 / 2.0, d3 / 2.0, d4);
    }

    public static double quantile(double d, double d2, double d3, double d4) {
        if (d2 <= 0.0 || d3 <= 0.0 || d4 < 0.0) {
            Utility.warning("F.quantile: must use positive df and lambda");
            return Double.NaN;
        }
        if (d < 0.0 || d >= 1.0) {
            Utility.warning("F.quantile: p is out of bounds");
            return Double.NaN;
        }
        double d5 = Beta.quantile(d, d2 / 2.0, d3 / 2.0, d4);
        return d3 / d2 * d5 / (1.0 - d5);
    }

    public static double quantile(double d, double d2, double d3) {
        return F.quantile(d, d2, d3, 0.0);
    }

    public static double power(double d, double d2, double d3, double d4) {
        if (d < 0.0 || d2 < 0.0 || d3 < 0.0 || d4 < 0.0 || d4 > 1.0) {
            Utility.warning("F.power: illegal argument");
            return Double.NaN;
        }
        double d5 = F.quantile(1.0 - d4, d2, d3);
        return 1.0 - F.cdf(d5, d2, d3, d);
    }

    public static double power(double d, double d2, double d3, double d4, boolean bl) {
        double d5 = F.quantile(1.0 - d4, d2, d3);
        if (bl) {
            return 1.0 - F.cdf(d5 / (1.0 + d), d2, d3, 0.0);
        }
        return 1.0 - F.cdf(d5, d2, d3, d2 * d);
    }

    public static double lambda(double d, double d2, double d3, double d4) {
        if (d < d4 || d > 1.0 || d2 < 0.0 || d3 < 0.0 || d4 < 0.0 || d4 > 1.0) {
            Utility.warning("F.lambda: illegal argument");
            return Double.NaN;
        }
        FAux fAux = new FAux(d2, d3, d4);
        double d5 = F.quantile(1.0 - d4, d2, d3) + F.quantile(d, d2, d3);
        return Solve.search(fAux, d, d5, 0.1);
    }

    public static double rocArea(double d, double d2, double d3, double d4) {
        saveLambda = d;
        saveDf1 = d2;
        saveDf2 = d3;
        return NumAnal.integral(class$rvl$stat$dist$F == null ? (class$rvl$stat$dist$F = F.class$("rvl.stat.dist.F")) : class$rvl$stat$dist$F, "power", 0.0, 1.0, d4, false, 0.0, 1.0);
    }

    public static double rocArea(double d, double d2, double d3) {
        return F.rocArea(d, d2, d3, 1.0E-4);
    }

    public static double rocArea(double d, double d2, double d3, boolean bl, double d4) {
        saveEffSize = d;
        saveDf1 = d2;
        saveDf2 = d3;
        saveRandom = bl;
        return NumAnal.integral(class$rvl$stat$dist$F == null ? (class$rvl$stat$dist$F = F.class$("rvl.stat.dist.F")) : class$rvl$stat$dist$F, "powerr", 0.0, 1.0, d4, false, 0.0, 1.0);
    }

    public static double rocArea(double d, double d2, double d3, boolean bl) {
        return F.rocArea(d, d2, d3, bl, 1.0E-4);
    }

    public static double power(double d) {
        return F.power(saveLambda, saveDf1, saveDf2, d);
    }

    public static double powerr(double d) {
        return F.power(saveEffSize, saveDf1, saveDf2, d, saveRandom);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

