/*
 * Decompiled with CFR 0.152.
 */
package rvl.stat.anova;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import rvl.awt.DoubleField;
import rvl.awt.GridLine;
import rvl.awt.IntField;
import rvl.awt.RVLayout;

public class EffectAdvisor
extends Frame {
    private int rows;
    private int cols;
    private int wid = 6;
    private int prec = -2;
    private double[] rm;
    private double[] cm;
    private double gm;
    private double rc;
    private double[][] cell;
    private double rsd;
    private double csd;
    private double rcsd;
    private double[] re;
    private double[] ce;
    private double[][] celle;
    private double minY;
    private double maxY;
    private double rrng;
    private double crng;
    private double rcrng;
    private double fuzz = 1.0E-4;
    private DoubleField[] rmFld;
    private DoubleField[] cmFld;
    private DoubleField gmFld;
    private DoubleField[][] cellFld;
    private DoubleField rsdFld;
    private DoubleField csdFld;
    private DoubleField rcsdFld;
    private DoubleField rrngFld;
    private DoubleField crngFld;
    private DoubleField rcrngFld;
    private IntField nRowFld = new IntField(2, 4);
    private IntField nColFld = new IntField(2, 4);
    private Canvas rowPlot;
    private Canvas colPlot;
    private Panel advisorCard;
    private Panel setupCard;
    private Panel dataPan;
    private CardLayout layout;
    private MenuBar menuBar;

    public EffectAdvisor() {
        this.gmFld = new DoubleField(0.0, this.wid, this.prec);
        this.gmFld.setBackground(Color.gray);
        this.rsdFld = new DoubleField(0.0, 5, -3);
        this.csdFld = new DoubleField(0.0, 5, -3);
        this.rcsdFld = new DoubleField(0.0, 5, -3);
        this.rsdFld.setBackground(Color.darkGray);
        this.csdFld.setBackground(Color.darkGray);
        this.rcsdFld.setBackground(Color.darkGray);
        this.rrngFld = new DoubleField(0.0, 4, -2);
        this.crngFld = new DoubleField(0.0, 4, -2);
        this.rcrngFld = new DoubleField(0.0, 4, -2);
        this.rrngFld.setBackground(Color.darkGray);
        this.crngFld.setBackground(Color.darkGray);
        this.rcrngFld.setBackground(Color.darkGray);
        Panel panel = new Panel();
        panel.setLayout(new RVLayout(3));
        panel.setBackground(Color.gray);
        panel.setForeground(Color.white);
        panel.add(new Label("Term", 0));
        panel.add(new Label("Effect SD", 1));
        panel.add(new Label("Range", 1));
        panel.add(new GridLine(0, Color.lightGray));
        panel.add(new GridLine(0, Color.lightGray));
        panel.add(new GridLine(0, Color.lightGray));
        panel.add(new Label("Rows", 0));
        panel.add(this.rsdFld);
        panel.add(this.rrngFld);
        panel.add(new Label("Cols", 0));
        panel.add(this.csdFld);
        panel.add(this.crngFld);
        panel.add(new Label("Rows*Cols", 0));
        panel.add(this.rcsdFld);
        panel.add(this.rcrngFld);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 2));
        this.rowPlot = new Canvas();
        this.colPlot = new Canvas();
        panel2.add(this.rowPlot);
        panel2.add(this.colPlot);
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        panel3.add("West", panel);
        panel3.add("Center", panel2);
        panel3.add("North", new GridLine(0, Color.black));
        this.menuBar = new MenuBar();
        Menu menu = new Menu("Options");
        menu.add(new MenuItem("New setup"));
        menu.add(new MenuItem("Reset values"));
        menu.add(new MenuItem("Reset window size"));
        menu.addSeparator();
        menu.add(new MenuItem("Min SD row effs"));
        menu.add(new MenuItem("Linear row effs"));
        menu.add(new MenuItem("Max SD row effs"));
        menu.addSeparator();
        menu.add(new MenuItem("Min SD col effs"));
        menu.add(new MenuItem("Linear col effs"));
        menu.add(new MenuItem("Max SD col effs"));
        menu.addSeparator();
        menu.add(new MenuItem("Min SD row*col effs"));
        menu.add(new MenuItem("Lin*lin row*col effs"));
        menu.add(new MenuItem("Max SD row*col effs"));
        menu.addSeparator();
        menu.add(new MenuItem("Quit"));
        this.menuBar.add(menu);
        this.setTitle("Effect Advisor setup");
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        this.setupCard = new Panel();
        this.setupCard.add(new Label("Rows"));
        this.setupCard.add(this.nRowFld);
        this.setupCard.add(new Label("        Columns"));
        this.setupCard.add(this.nColFld);
        this.setupCard.add(new Label("        "));
        this.setupCard.add(new Button("OK"));
        this.add("setup", this.setupCard);
        this.advisorCard = new Panel();
        this.advisorCard.setLayout(new BorderLayout());
        this.advisorCard.add("South", panel3);
        this.add("advisor", this.advisorCard);
        this.layout.show(this, "setup");
        this.pack();
        this.show();
    }

    private Panel dataPanel(int n, int n2) {
        int n3;
        int n4;
        this.rows = n;
        this.cols = n2;
        this.rc = n * n2;
        this.rm = new double[n];
        this.re = new double[n];
        this.rmFld = new DoubleField[n];
        this.cm = new double[n2];
        this.ce = new double[n2];
        this.cmFld = new DoubleField[n2];
        this.cell = new double[n][];
        this.celle = new double[n][];
        this.cellFld = new DoubleField[n][];
        for (n4 = 0; n4 < n; ++n4) {
            this.rmFld[n4] = new DoubleField(0.0, this.wid, this.prec);
            this.rmFld[n4].setBackground(Color.pink);
            this.cell[n4] = new double[n2];
            this.celle[n4] = new double[n2];
            this.cellFld[n4] = new DoubleField[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                this.cellFld[n4][n3] = new DoubleField(0.0, this.wid, this.prec);
                this.cellFld[n4][n3].setBackground(Color.white);
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            this.cmFld[n4] = new DoubleField(0.0, this.wid, this.prec);
            this.cmFld[n4].setBackground(Color.pink);
        }
        Panel panel = new Panel();
        panel.setLayout(new RVLayout(n2 + 2, 0, 0, false, true));
        for (n3 = 0; n3 < n; ++n3) {
            for (int i = 0; i < n2; ++i) {
                panel.add(this.cellFld[n3][i]);
            }
            panel.add(new GridLine(1, Color.red));
            panel.add(this.rmFld[n3]);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            panel.add(new GridLine(0, Color.red));
        }
        panel.add(new GridLine(2, Color.red));
        panel.add(new GridLine(0, Color.red));
        for (n3 = 0; n3 < n2; ++n3) {
            panel.add(this.cmFld[n3]);
        }
        panel.add(new GridLine(1, Color.red));
        panel.add(this.gmFld);
        return panel;
    }

    private synchronized void updateEffs() {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        this.gm = 0.0;
        int n2 = 0;
        while (n2 < this.cols) {
            this.cm[n2++] = 0.0;
        }
        this.minY = this.maxY = this.cell[0][0];
        for (n2 = 0; n2 < this.rows; ++n2) {
            this.rm[n2] = 0.0;
            for (n = 0; n < this.cols; ++n) {
                int n3 = n2;
                this.rm[n3] = this.rm[n3] + this.cell[n2][n] / (double)this.cols;
                int n4 = n;
                this.cm[n4] = this.cm[n4] + this.cell[n2][n] / (double)this.rows;
                this.gm += this.cell[n2][n] / this.rc;
                if (this.cell[n2][n] < this.minY) {
                    this.minY = this.cell[n2][n];
                }
                if (!(this.cell[n2][n] > this.maxY)) continue;
                this.maxY = this.cell[n2][n];
            }
            this.rmFld[n2].setValue(this.rm[n2]);
        }
        for (n2 = 0; n2 < this.cols; ++n2) {
            this.cmFld[n2].setValue(this.cm[n2]);
        }
        this.gmFld.setValue(this.gm);
        this.rcsd = 0.0;
        this.csd = 0.0;
        this.rsd = 0.0;
        for (n2 = 0; n2 < this.rows; ++n2) {
            this.re[n2] = this.rm[n2] - this.gm;
            if (this.re[n2] < d6) {
                d6 = this.re[n2];
            }
            if (this.re[n2] > d5) {
                d5 = this.re[n2];
            }
            this.rsd += this.re[n2] * this.re[n2];
            for (n = 0; n < this.cols; ++n) {
                this.celle[n2][n] = this.cell[n2][n] - this.re[n2] - this.cm[n];
                this.rcsd += this.celle[n2][n] * this.celle[n2][n];
                if (this.celle[n2][n] < d2) {
                    d2 = this.celle[n2][n];
                }
                if (!(this.celle[n2][n] > d)) continue;
                d = this.celle[n2][n];
            }
        }
        for (n2 = 0; n2 < this.cols; ++n2) {
            this.ce[n2] = this.cm[n2] - this.gm;
            if (this.ce[n2] < d4) {
                d4 = this.ce[n2];
            }
            if (this.ce[n2] > d3) {
                d3 = this.ce[n2];
            }
            this.csd += this.ce[n2] * this.ce[n2];
        }
        this.rsd = Math.sqrt(this.rsd / (double)(this.rows - 1));
        this.csd = Math.sqrt(this.csd / (double)(this.cols - 1));
        this.rcsd = Math.sqrt(this.rcsd / (double)(this.rows - 1) / (double)(this.cols - 1));
        this.rsdFld.setValue(this.rsd);
        this.csdFld.setValue(this.csd);
        this.rcsdFld.setValue(this.rcsd);
        this.rrng = d5 - d6;
        this.crng = d3 - d4;
        this.rcrng = d - d2;
        this.rrngFld.setValue(this.rrng);
        this.crngFld.setValue(this.crng);
        this.rcrngFld.setValue(this.rcrng);
        this.updatePlots();
    }

    private synchronized void updateRow(int n, double d, boolean bl) {
        double d2 = d - this.rm[n];
        for (int i = 0; i < this.cols; ++i) {
            double[] dArray = this.cell[n];
            int n2 = i;
            dArray[n2] = dArray[n2] + d2;
            this.cellFld[n][i].setValue(this.cell[n][i]);
        }
        if (bl) {
            this.updateEffs();
        }
    }

    private synchronized void updateCol(int n, double d, boolean bl) {
        double d2 = d - this.cm[n];
        for (int i = 0; i < this.rows; ++i) {
            double[] dArray = this.cell[i];
            int n2 = n;
            dArray[n2] = dArray[n2] + d2;
            this.cellFld[i][n].setValue(this.cell[i][n]);
        }
        if (bl) {
            this.updateEffs();
        }
    }

    private synchronized void updateGM(double d) {
        for (int i = 0; i < this.rows; ++i) {
            this.updateRow(i, d + this.re[i], false);
        }
        this.updateEffs();
    }

    private synchronized void rescaleEffs(double d, double d2, double d3) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.cell[i][j] = this.gm + d * this.re[i] + d2 * this.ce[j] + d3 * this.celle[i][j];
                this.cellFld[i][j].setValue(this.cell[i][j]);
            }
        }
        this.updateEffs();
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.dispose();
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        int n;
        if (object.equals("OK")) {
            this.setTitle("Setting up Effect Advisor ...");
            if (this.dataPan != null) {
                this.advisorCard.remove(this.dataPan);
            }
            int n2 = this.nRowFld.getValue();
            int n3 = this.nColFld.getValue();
            n2 = Math.max(n2, 2);
            n3 = Math.max(n3, 2);
            this.dataPan = this.dataPanel(n2, n3);
            this.updateGM(0.0);
            this.rescaleEffs(0.0, 0.0, 0.0);
            this.advisorCard.add("North", this.dataPan);
            this.setTitle("Effect Advisor");
            this.setMenuBar(this.menuBar);
            this.layout.show(this, "advisor");
            this.pack();
            return true;
        }
        if (object.equals("New setup")) {
            this.setTitle("Effect Advisor Setup");
            this.remove(this.menuBar);
            this.layout.show(this, "setup");
            this.pack();
            return true;
        }
        if (object.equals("Quit")) {
            this.dispose();
        }
        if (event.target.equals(this.gmFld)) {
            this.updateGM(this.gmFld.getValue());
            return true;
        }
        if (event.target.equals(this.rsdFld)) {
            this.rescaleEffs(this.rsdFld.getValue() / this.rsd, 1.0, 1.0);
            return true;
        }
        if (event.target.equals(this.csdFld)) {
            this.rescaleEffs(1.0, this.csdFld.getValue() / this.csd, 1.0);
            return true;
        }
        if (event.target.equals(this.rcsdFld)) {
            this.rescaleEffs(1.0, 1.0, this.rcsdFld.getValue() / this.rcsd);
            return true;
        }
        if (event.target.equals(this.rrngFld)) {
            this.rescaleEffs(this.rrngFld.getValue() / this.rrng, 1.0, 1.0);
            return true;
        }
        if (event.target.equals(this.crngFld)) {
            this.rescaleEffs(1.0, this.crngFld.getValue() / this.crng, 1.0);
            return true;
        }
        if (event.target.equals(this.rcrngFld)) {
            this.rescaleEffs(1.0, 1.0, this.rcrngFld.getValue() / this.rcrng);
            return true;
        }
        for (n = 0; n < this.rows; ++n) {
            if (!event.target.equals(this.rmFld[n])) continue;
            this.updateRow(n, this.rmFld[n].getValue(), true);
            return true;
        }
        for (n = 0; n < this.cols; ++n) {
            if (!event.target.equals(this.cmFld[n])) continue;
            this.updateCol(n, this.cmFld[n].getValue(), true);
            return true;
        }
        for (n = 0; n < this.rows; ++n) {
            for (int i = 0; i < this.cols; ++i) {
                if (!event.target.equals(this.cellFld[n][i])) continue;
                this.cell[n][i] = this.cellFld[n][i].getValue();
                this.updateEffs();
                return true;
            }
        }
        if (object.equals("Reset values")) {
            this.rescaleEffs(0.0, 0.0, 0.0);
            this.updateGM(0.0);
            return true;
        }
        if (object.equals("Reset window size")) {
            this.pack();
            return true;
        }
        if (object.equals("Min SD row effs")) {
            double d = this.rrng > this.fuzz ? 0.5 * this.rrng : 1.0;
            this.rescaleEffs(0.0, 1.0, 1.0);
            this.re[0] = -1.0;
            this.re[this.rows - 1] = 1.0;
            this.rescaleEffs(d, 1.0, 1.0);
            return true;
        }
        if (object.equals("Linear row effs")) {
            double d = this.rrng > this.fuzz ? 0.5 * this.rrng : 1.0;
            for (int i = 0; i < this.rows; ++i) {
                this.re[i] = ((double)(2 * i - this.rows) + 1.0) / ((double)this.rows - 1.0);
            }
            this.rescaleEffs(d, 1.0, 1.0);
            return true;
        }
        if (object.equals("Max SD row effs")) {
            double d = this.rrng > this.fuzz ? 0.5 * this.rrng : 1.0;
            this.re[(this.rows - 1) / 2] = 0.0;
            for (int i = 0; i < this.rows / 2; ++i) {
                this.re[i] = -1.0;
                this.re[this.rows - i - 1] = 1.0;
            }
            this.rescaleEffs(d, 1.0, 1.0);
            return true;
        }
        if (object.equals("Min SD col effs")) {
            double d = this.crng > this.fuzz ? 0.5 * this.crng : 1.0;
            this.rescaleEffs(1.0, 0.0, 1.0);
            this.ce[0] = -1.0;
            this.ce[this.cols - 1] = 1.0;
            this.rescaleEffs(1.0, d, 1.0);
            return true;
        }
        if (object.equals("Linear col effs")) {
            double d = this.crng > this.fuzz ? 0.5 * this.crng : 1.0;
            for (int i = 0; i < this.cols; ++i) {
                this.ce[i] = ((double)(2 * i - this.cols) + 1.0) / ((double)this.cols - 1.0);
            }
            this.rescaleEffs(1.0, d, 1.0);
            return true;
        }
        if (object.equals("Max SD col effs")) {
            double d = this.crng > this.fuzz ? 0.5 * this.crng : 1.0;
            this.ce[(this.cols - 1) / 2] = 0.0;
            for (int i = 0; i < this.cols / 2; ++i) {
                this.ce[i] = -1.0;
                this.ce[this.cols - i - 1] = 1.0;
            }
            this.rescaleEffs(1.0, d, 1.0);
            return true;
        }
        if (object.equals("Min SD row*col effs")) {
            double d = this.rcrng > this.fuzz ? 0.5 * this.rcrng : 1.0;
            this.rescaleEffs(1.0, 1.0, 0.0);
            this.celle[this.rows - 1][this.cols - 1] = 1.0;
            this.celle[0][0] = 1.0;
            this.celle[this.rows - 1][0] = -1.0;
            this.celle[0][this.cols - 1] = -1.0;
            this.rescaleEffs(1.0, 1.0, d);
            return true;
        }
        if (object.equals("Lin*lin row*col effs")) {
            double d = this.rcrng > this.fuzz ? 0.5 * this.rcrng : 1.0;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.cols; ++j) {
                    this.celle[i][j] = (double)((2 * i - this.rows + 1) * (2 * j - this.cols + 1)) / ((double)this.rows - 1.0) / ((double)this.cols - 1.0);
                }
            }
            this.rescaleEffs(1.0, 1.0, d);
            return true;
        }
        if (object.equals("Max SD row*col effs")) {
            double d = this.rcrng > this.fuzz ? 0.5 * this.rcrng : 1.0;
            this.rescaleEffs(1.0, 1.0, 0.0);
            for (int i = 0; i < this.rows / 2; ++i) {
                for (int j = 0; j < this.cols / 2; ++j) {
                    this.celle[this.rows - i - 1][this.cols - j - 1] = 1.0;
                    this.celle[i][j] = 1.0;
                    this.celle[this.rows - i - 1][j] = -1.0;
                    this.celle[i][this.cols - j - 1] = -1.0;
                }
            }
            this.rescaleEffs(1.0, 1.0, d);
            return true;
        }
        return super.action(event, object);
    }

    private void updatePlots() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Color[] colorArray = new Color[]{Color.black, Color.blue, Color.red, Color.orange, Color.cyan, Color.magenta};
        int n7 = this.rowPlot.size().width;
        int n8 = this.rowPlot.size().height;
        int n9 = n8 / 2;
        double d = 0.0;
        if (this.minY < this.maxY) {
            d = (double)(n8 - 30) / (this.maxY - this.minY);
            n9 = 20;
        }
        Graphics graphics = this.drawCanv(this.rowPlot, "Row profiles");
        int n10 = (n7 - 20) / (this.cols - 1);
        for (n6 = this.rows - 1; n6 >= 0; --n6) {
            graphics.setColor(colorArray[n6 % 6]);
            n5 = 0;
            n4 = 0;
            for (n3 = 0; n3 < this.cols; ++n3) {
                n2 = n9 + (int)(d * (this.maxY - this.cell[n6][n3]) + 0.5);
                n = 10 + n3 * n10;
                graphics.fillOval(n - 2, n2 - 2, 5, 5);
                if (n3 > 0) {
                    graphics.drawLine(n4, n5, n, n2);
                }
                n5 = n2;
                n4 = n;
            }
        }
        graphics = this.drawCanv(this.colPlot, "Column profiles");
        n10 = (n7 - 20) / (this.rows - 1);
        for (n6 = this.cols - 1; n6 >= 0; --n6) {
            graphics.setColor(colorArray[n6 % 6]);
            n5 = 0;
            n4 = 0;
            for (n3 = 0; n3 < this.rows; ++n3) {
                n2 = n9 + (int)(d * (this.maxY - this.cell[n3][n6]) + 0.5);
                n = 10 + n3 * n10;
                graphics.fillOval(n - 2, n2 - 2, 5, 5);
                if (n3 > 0) {
                    graphics.drawLine(n4, n5, n, n2);
                }
                n5 = n2;
                n4 = n;
            }
        }
    }

    private Graphics drawCanv(Canvas canvas, String string) {
        Graphics graphics = canvas.getGraphics();
        int n = canvas.size().width;
        int n2 = canvas.size().height;
        graphics.setColor(Color.white);
        graphics.fill3DRect(5, 15, n - 10, n2 - 20, true);
        graphics.setColor(Color.black);
        graphics.setFont(new Font("Helvetica", 0, 8));
        graphics.drawString(string, 5, 10);
        return graphics;
    }

    public void paint(Graphics graphics) {
        this.updatePlots();
    }

    public static void main(String[] stringArray) {
        EffectAdvisor effectAdvisor = new EffectAdvisor();
    }
}

