/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface.apps;

import rvl.piface.Piface;
import rvl.stat.dist.F;

public class TwoVarGUI
extends Piface {
    private static String title = "Test of equality of two variances";
    public double var1;
    public double var2;
    public double n1;
    public double n2;
    public double Alpha;
    public double Power;
    public int eq;
    public int alt;
    public int cc;
    static /* synthetic */ Class class$rvl$piface$apps$AnovaPicker;

    public void gui() {
        this.beginSubpanel(2, true);
        this.bar("n1", 100.0);
        this.bar("var1", "Variance 1", 1.5);
        this.bar("n2", 100.0);
        this.bar("var2", "Variance 2", 1.0);
        this.checkbox("eq", "Equal ns", 1);
        this.choice("alt", "Alternative", new String[]{"Var1 < Var2", "Var1 != Var2", "Var1 > Var2"}, 1);
        this.endSubpanel();
        this.beginSubpanel(2, true);
        this.bar("Alpha", 0.05);
        this.ointerval("Power", 0.5, 0.0, 1.0);
        this.endSubpanel();
        this.menuItem("localHelp", "This dialog", this.helpMenu);
    }

    public void click() {
        this.n1 = TwoVarGUI.max(2.0, TwoVarGUI.round(this.n1));
        if (this.eq == 1) {
            this.n2 = this.n1;
        }
        this.calcPower();
    }

    public void n2_changed() {
        this.n2 = TwoVarGUI.max(TwoVarGUI.round(this.n2), 2.0);
        if (this.eq == 1) {
            this.n1 = this.n2;
        }
        this.calcPower();
    }

    private void calcPower() {
        double d;
        double d2;
        double d3;
        if (this.alt >= 1) {
            d3 = this.n1 - 1.0;
            d2 = this.n2 - 1.0;
            d = this.var1 / this.var2;
        } else {
            d3 = this.n2 - 1.0;
            d2 = this.n1 - 1.0;
            d = this.var2 / this.var1;
        }
        double d4 = this.alt == 1 ? this.Alpha / 2.0 : this.Alpha;
        double d5 = F.quantile(1.0 - d4, d3, d2);
        this.Power = 1.0 - F.cdf(d5 / d, d3, d2);
        if (this.alt == 1) {
            d5 = F.quantile(1.0 - d4, d2, d3);
            this.Power += 1.0 - F.cdf(d5 * d, d2, d3);
        }
    }

    public void localHelp() {
        this.showText(class$rvl$piface$apps$AnovaPicker == null ? (class$rvl$piface$apps$AnovaPicker = TwoVarGUI.class$("rvl.piface.apps.AnovaPicker")) : class$rvl$piface$apps$AnovaPicker, "TwoVarGUIHelp.txt", "Power analysis help: Comparing two variances", 25, 60);
    }

    public TwoVarGUI() {
        super(title);
    }

    public static void main(String[] stringArray) {
        TwoVarGUI twoVarGUI = new TwoVarGUI();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

