/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface.apps;

import rvl.piface.Piface;
import rvl.stat.dist.Poisson;

public class SimplePoissonGUI
extends Piface {
    private static String title = "Power of a Simple Poisson Test";
    public double lambda0;
    public double lambda;
    public double alpha;
    public double power;
    public double size;
    public double lower;
    public double upper;
    public double n;
    public int alt;
    static /* synthetic */ Class class$rvl$piface$apps$SimplePoissonGUI;

    public void gui() {
        this.bar("lambda0", 1.0);
        this.choice("alt", "alternative", new String[]{"lambda < lambda0", "lambda != lambda0", "lambda > lambda0"}, 1);
        this.field("alpha", 0.05);
        this.label("Boundaries of acceptance region");
        this.beginSubpanel(2, false);
        this.otext("lower", "lower", 0.0);
        this.otext("upper", "upper", 0.0);
        this.endSubpanel();
        this.otext("size", "size", 0.0);
        this.bar("lambda", 1.0);
        this.bar("n", 50.0);
        this.ointerval("power", 0.0, 0.0, 1.0);
        this.menuItem("localHelp", "This dialog", this.helpMenu);
    }

    public void click() {
        double d = this.alt == 1 ? this.alpha / 2.0 : this.alpha;
        this.power = 0.0;
        this.size = 0.0;
        if (this.alt < 2) {
            this.lower = Poisson.quantile(d, this.n * this.lambda0) + 1;
            this.size += Poisson.cdf((int)this.lower - 1, this.n * this.lambda0);
            this.power += Poisson.cdf((int)this.lower - 1, this.n * this.lambda);
        }
        if (this.alt > 0) {
            this.upper = Poisson.quantile(1.0 - d, this.n * this.lambda0);
            this.size += 1.0 - Poisson.cdf((int)this.upper + 1, this.n * this.lambda0);
            this.power += 1.0 - Poisson.cdf((int)this.upper + 1, this.n * this.lambda);
        }
    }

    public void alt_changed() {
        this.setVisible("lower", this.alt < 2);
        this.setVisible("upper", this.alt > 0);
        this.click();
    }

    public void localHelp() {
        this.showText(class$rvl$piface$apps$SimplePoissonGUI == null ? (class$rvl$piface$apps$SimplePoissonGUI = SimplePoissonGUI.class$("rvl.piface.apps.SimplePoissonGUI")) : class$rvl$piface$apps$SimplePoissonGUI, "SimplePoissonGUIHelp.txt", "Power analysis help: Simple Poisson test", 25, 60);
    }

    public SimplePoissonGUI() {
        super(title);
    }

    public static void main(String[] stringArray) {
        new SimplePoissonGUI();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

