/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface.apps;

import rvl.piface.Piface;
import rvl.stat.dist.Rsquare;

public class RsquareGUI
extends Piface {
    private static String title = "Power of a Test of R-square";
    public double rho2;
    public double n;
    public double alpha;
    public double power;
    public double preds;
    static /* synthetic */ Class class$rvl$piface$apps$RsquareGUI;

    public void gui() {
        this.field("alpha", 0.05);
        this.bar("rho2", "True rho^2 value", 0.1);
        this.bar("n", "Sample size", 50.0);
        this.bar("preds", "No. of regressors", 1.0);
        this.ointerval("power", 0.0, 0.0, 1.0);
        this.menuItem("localHelp", "This dialog", this.helpMenu);
    }

    public void click() {
        this.preds = this.preds < 1.0 ? 1.0 : (double)RsquareGUI.round(this.preds);
        int n = (int)this.preds + 1;
        this.n = RsquareGUI.max(this.n, this.preds + 1.0);
        this.rho2 = RsquareGUI.min(this.rho2, 0.999);
        this.alpha = RsquareGUI.max(1.0E-4, RsquareGUI.min(0.5, this.alpha));
        double d = Rsquare.quantile(1.0 - this.alpha, this.n, n);
        this.power = 1.0 - Rsquare.cdf(d, this.n, n, this.rho2);
    }

    public void localHelp() {
        this.showText(class$rvl$piface$apps$RsquareGUI == null ? (class$rvl$piface$apps$RsquareGUI = RsquareGUI.class$("rvl.piface.apps.RsquareGUI")) : class$rvl$piface$apps$RsquareGUI, "RsquareGUIHelp.txt", "Power analysis help: Generic Chi^2 test", 25, 60);
    }

    public RsquareGUI() {
        super(title);
    }

    public static void main(String[] stringArray) {
        new RsquareGUI();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

