/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface.apps;

import rvl.piface.Piface;
import rvl.stat.dist.Normal;
import rvl.stat.dist.T;

public class OneTCIGUI
extends Piface {
    private static String title = "CI for a mean";
    public double conf;
    public double N;
    public double n;
    public double Sigma;
    public double ME;
    public double tCrit;
    public int isFinite;
    static /* synthetic */ Class class$rvl$piface$apps$OneTCIGUI;

    public void gui() {
        this.beginSubpanel(2);
        this.checkbox("isFinite", "Finite population", 1);
        this.field("N", "N", 1000.0, 8, 6);
        this.endSubpanel();
        this.choice("conf", "Confidence", new double[]{0.9, 0.95, 0.98, 0.99, 0.995}, 1);
        this.bar("Sigma", 1.0);
        this.bar("ME", "Margin of Error", 0.2);
        this.bar("n", 25.0);
        this.menuItem("localHelp", "This dialog", this.helpMenu);
        this.n = 25.0;
        this.conf = 0.95;
        this.n_changed();
    }

    public void click() {
        this.tCrit = Normal.quantile(1.0 - (1.0 - this.conf) / 2.0);
        this.ME = OneTCIGUI.max(this.ME, 0.001 * this.Sigma);
        for (int i = 0; i < 3; ++i) {
            this.n = this.tCrit * this.Sigma / this.ME;
            this.n *= this.n;
            if (this.isFinite == 1) {
                this.n /= 1.0 + this.n / this.N;
            }
            this.n = OneTCIGUI.max(2.0, this.n);
            this.tCrit = T.quantile(1.0 - (1.0 - this.conf) / 2.0, this.n - 1.0);
        }
    }

    public void n_changed() {
        this.N = OneTCIGUI.max(2.0, OneTCIGUI.round(this.N));
        this.n = OneTCIGUI.max(2.0, OneTCIGUI.round(this.n));
        this.tCrit = T.quantile(1.0 - (1.0 - this.conf) / 2.0, this.n - 1.0);
        this.ME = this.tCrit * this.Sigma / OneTCIGUI.sqrt(this.n);
        if (this.isFinite == 1) {
            this.ME *= OneTCIGUI.sqrt(1.0 - this.n / this.N);
        }
    }

    public void isFinite_changed() {
        this.setVisible("N", this.isFinite == 1);
        this.click();
    }

    public void localHelp() {
        this.showText(class$rvl$piface$apps$OneTCIGUI == null ? (class$rvl$piface$apps$OneTCIGUI = OneTCIGUI.class$("rvl.piface.apps.OneTCIGUI")) : class$rvl$piface$apps$OneTCIGUI, "OneTCIGUIHelp.txt", "Help: One-sample CI for a mean", 25, 60);
    }

    public OneTCIGUI() {
        super(title);
    }

    public static void main(String[] stringArray) {
        new OneTCIGUI();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

