/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface.apps;

import java.awt.Component;
import rvl.piface.Piface;
import rvl.piface.PifaceAux;
import rvl.stat.dist.Beta;
import rvl.stat.dist.Binomial;
import rvl.stat.dist.Normal;

public class OnePGUI
extends Piface {
    private static String title = "Sample size for one proportion";
    private Component sizeComp;
    public double p0;
    public double p;
    public double n;
    public double Alpha;
    public double Power;
    public double Size;
    public int Method;
    public int alt;
    static /* synthetic */ Class class$rvl$piface$apps$AnovaPicker;

    public void gui() {
        this.interval("p0", "Null value (p0)", 0.5, 0.0, 1.0);
        this.interval("p", "Actual value (p)", 0.6, 0.0, 1.0);
        this.bar("n", "Sample size", 50.0);
        this.beginSubpanel(2, false);
        this.choice("alt", "Alternative", new String[]{"p < p0", "p != p0", "p > p0"}, 1);
        this.choice("Alpha", new double[]{0.005, 0.01, 0.02, 0.05, 0.1, 0.2}, 3);
        this.choice("Method", new String[]{"Exact", "Normal approx", "Beta approx", "Exact (Wald CV)"}, 1);
        this.otext("Size", "Size", 0.06);
        this.endSubpanel();
        this.interval("Power", 0.0, 0.0, 1.0);
        this.sizeComp = (Component)((Object)this.getComponent("Size"));
        this.sizeComp.setVisible(false);
        this.menuItem("localHelp", "This dialog", this.helpMenu);
    }

    public void click() {
        double[] dArray = new double[2];
        int n = this.alt - 1;
        this.n = Piface.max(2.0, Piface.round(this.n));
        this.p0 = Piface.min(Piface.max(this.p0, 0.01), 0.99);
        this.p = Piface.min(Piface.max(this.p, 0.01), 0.99);
        switch (this.Method) {
            case 0: {
                dArray = Binomial.power(this.p0, this.p, (int)this.n, n, this.Alpha);
                this.Power = dArray[0];
                this.Size = dArray[1];
                break;
            }
            case 1: {
                double d = Piface.sqrt(this.p0 * (1.0 - this.p0) / this.n);
                double d2 = Piface.sqrt(this.p * (1.0 - this.p) / this.n);
                this.Power = this.nPower(this.p0, d, this.p, d2, n, this.Alpha);
                this.Size = this.Alpha;
                break;
            }
            case 2: {
                this.Power = this.bPower((this.n - 1.0) * this.p0, (this.n - 1.0) * (1.0 - this.p0), (this.n - 1.0) * this.p, (this.n - 1.0) * (1.0 - this.p), n, this.Alpha);
                this.Size = this.Alpha;
                break;
            }
            case 3: {
                dArray = Binomial.waldPower(this.p0, this.p, (int)this.n, n, this.Alpha);
                this.Power = dArray[0];
                this.Size = dArray[1];
            }
        }
    }

    public void Method_changed() {
        this.sizeComp.setVisible(this.Method == 0 || this.Method == 3);
        this.click();
    }

    double nPower(double d, double d2, double d3, double d4, int n, double d5) {
        if (n > 0) {
            double d6 = Normal.quantile(1.0 - d5, d, d2);
            return 1.0 - Normal.cdf(d6, d3, d4);
        }
        if (n < 0) {
            double d7 = Normal.quantile(d5, d, d2);
            return Normal.cdf(d7, d3, d4);
        }
        double d8 = Normal.quantile(d5 / 2.0, d, d2);
        double d9 = Normal.quantile(1.0 - d5 / 2.0, d, d2);
        return 1.0 + Normal.cdf(d8, d3, d4) - Normal.cdf(d9, d3, d4);
    }

    double bPower(double d, double d2, double d3, double d4, int n, double d5) {
        if (n > 0) {
            double d6 = Beta.quantile(1.0 - d5, d, d2);
            return 1.0 - Beta.cdf(d6, d3, d4);
        }
        if (n < 0) {
            double d7 = Beta.quantile(d5, d, d2);
            return Beta.cdf(d7, d3, d4);
        }
        double d8 = Beta.quantile(d5 / 2.0, d, d2);
        double d9 = Beta.quantile(1.0 - d5 / 2.0, d, d2);
        return 1.0 + Beta.cdf(d8, d3, d4) - Beta.cdf(d9, d3, d4);
    }

    public void Power_changed() {
        this.Power = Piface.min(0.99, Piface.max(this.Alpha, this.Power));
        PifaceAux pifaceAux = new PifaceAux("n", "Power", this);
        pifaceAux.closedMin = true;
        pifaceAux.xMin = 2.0;
        pifaceAux.xeps = 0.5;
        this.n = this.solve(pifaceAux, this.Power, this.n, 20.0);
        this.click();
    }

    public void localHelp() {
        this.showText(class$rvl$piface$apps$AnovaPicker == null ? (class$rvl$piface$apps$AnovaPicker = OnePGUI.class$("rvl.piface.apps.AnovaPicker")) : class$rvl$piface$apps$AnovaPicker, "OnePGUIHelp.txt", "Power analysis help: Test of one proportion", 25, 60);
    }

    public OnePGUI() {
        super(title);
    }

    public static void main(String[] stringArray) {
        OnePGUI onePGUI = new OnePGUI();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

