/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface.apps;

import java.awt.Color;
import rvl.piface.Piface;
import rvl.stat.dist.T;

public class LinRegGUI
extends Piface {
    private static String title = "Linear Regression";
    public double k;
    public double n;
    public double sdx;
    public double vif;
    public double beta;
    public double sderr;
    public double alpha;
    public double power;
    public int tt;
    public int opt;
    static /* synthetic */ Class class$rvl$piface$apps$AnovaPicker;

    public void gui() {
        this.setBackground(new Color(230, 230, 230));
        this.beginSubpanel(1, Color.blue.darker());
        this.slider("k", "No. of predictors", 1.0, 1.0, 8.0, 1, true, false, true);
        this.bar("sdx", "SD of x[j]", 1.0);
        this.slider("vif", "VIF[j]", 1.0, 1.0, 10.0, 4, true, false, true);
        this.endSubpanel();
        this.bar("alpha", "Alpha", 0.05);
        this.checkbox("tt", "Two-tailed", 1);
        this.newColumn();
        this.bar("sderr", "Error SD", 1.0);
        this.bar("beta", "Detectable beta[j]", 1.0);
        this.bar("n", "Sample size", 10.0);
        this.beginSubpanel(1, Color.blue.darker());
        this.interval("power", "Power", 0.5, 0.0, 1.0);
        this.choice("opt", "Solve for", new String[]{"Sample size", "Detectable beta[j]"}, 0);
        this.endSubpanel();
        this.menuItem("localHelp", "Regression dialog help", this.helpMenu);
    }

    public void click() {
        this.k = LinRegGUI.round(LinRegGUI.max(1.0, this.k));
        this.n = LinRegGUI.round(LinRegGUI.max(this.k + 2.0, this.n));
        this.alpha = LinRegGUI.min(0.999, LinRegGUI.max(0.001, this.alpha));
        if (this.k > 1.5) {
            this.vif = LinRegGUI.max(1.0, this.vif);
            this.setVisible("vif", true);
        } else {
            this.vif = 1.0;
            this.setVisible("vif", false);
        }
        this.calcPower();
    }

    public void power_changed() {
        this.power = LinRegGUI.min(0.999, LinRegGUI.max(0.001, this.power));
        switch (this.opt) {
            case 0: {
                this.beta = LinRegGUI.max(0.001 * this.sderr / this.sdx, this.beta);
                double d = this.vif * LinRegGUI.pow(this.sderr / (this.beta * this.sdx), 2.0);
                for (int i = 0; i < 3; ++i) {
                    double d2 = T.delta(this.power, this.n - this.k - 1.0, 1 - this.tt, this.alpha);
                    this.n = LinRegGUI.max(this.k + 1.0, d * d2 * d2);
                }
                this.n = LinRegGUI.round(this.n);
                break;
            }
            case 1: {
                double d = T.delta(this.power, this.n - this.k - 1.0, 1 - this.tt, this.alpha);
                this.beta = d * LinRegGUI.sqrt(this.vif / this.n) * this.sderr / this.sdx;
            }
        }
        this.calcPower();
    }

    private void calcPower() {
        double d = LinRegGUI.sqrt(this.vif / this.n) * this.sderr / this.sdx;
        double d2 = this.beta / d;
        double d3 = this.n - this.k - 1.0;
        this.power = T.power(d2, d3, 1 - this.tt, this.alpha);
    }

    public void localHelp() {
        this.showText(class$rvl$piface$apps$AnovaPicker == null ? (class$rvl$piface$apps$AnovaPicker = LinRegGUI.class$("rvl.piface.apps.AnovaPicker")) : class$rvl$piface$apps$AnovaPicker, "LinRegGUIHelp.txt", "Power analysis help: Linear regression", 25, 60);
    }

    public LinRegGUI() {
        super(title);
    }

    public static void main(String[] stringArray) {
        new LinRegGUI();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

