/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface.apps;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import rvl.awt.IntPlot;
import rvl.awt.Plot;
import rvl.piface.PiPanel;
import rvl.piface.Piface;

public class Fractal
extends Piface {
    private static String title = "Interactive fractals";
    private int n = 0;
    private double[] x;
    private double[] y;
    private double[] patx;
    private double[] paty;
    private Plot outPlot;
    private IntPlot inPlot;
    public double recur;
    public double npat;

    public void gui() {
        this.patx = new double[]{0.0, 0.25, 0.5, 0.75, 1.0};
        this.paty = new double[]{0.0, 0.0, 0.25, 0.0, 0.0};
        this.inPlot = new IntPlot(this.patx, this.paty);
        this.inPlot.setLineMode(true);
        this.inPlot.setDotMode(true);
        this.inPlot.setAxisLabels(new String[]{"x"}, new String[]{"y"});
        this.inPlot.setSameScale(true);
        this.outPlot = new Plot(this.patx, this.paty);
        this.outPlot.setLineMode(true);
        this.outPlot.setDotMode(false);
        this.outPlot.setTickMode(true, true);
        this.outPlot.setAxisLabels(new String[]{"x"}, new String[]{"y"});
        this.outPlot.setLineColor(Color.orange.darker());
        this.outPlot.setSameScale(true);
        this.panel.setLayout(new BorderLayout());
        this.beginSubpanel(2);
        this.component("pattern_changed", this.inPlot);
        this.beginSubpanel(1, Color.blue);
        this.choice("recur", "Number of recursions", new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0}, 2);
        this.choice("npat", "Number of points in pattern", new double[]{3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0}, 2);
        this.endSubpanel();
        this.panel.setStretchable(true);
        PiPanel piPanel = this.panel;
        this.endSubpanel();
        this.panel.add((Component)piPanel, "North");
        this.panel.add((Component)this.outPlot, "Center");
    }

    public void click() {
        this.doFractal((int)this.recur);
    }

    public void pattern_changed() {
        double[] dArray = this.inPlot.getXData()[0];
        double[] dArray2 = this.inPlot.getYData()[0];
        int n = this.patx.length - 1;
        if (dArray[0] != 0.0 || dArray2[0] != 0.0 || dArray[n] != 1.0 || dArray2[n] != 0.0) {
            this.paty[n] = 0.0;
            this.paty[0] = 0.0;
            this.patx[0] = 0.0;
            this.patx[n] = 1.0;
            this.inPlot.setData(this.patx, this.paty);
            return;
        }
        this.patx = dArray;
        this.paty = dArray2;
        this.doFractal((int)this.recur);
    }

    public void npat_changed() {
        int n = (int)this.npat;
        int n2 = this.patx.length;
        double[] dArray = this.paty;
        this.patx = new double[n];
        this.paty = new double[n];
        int n3 = 0;
        while (n3 < n) {
            this.paty[n3] = n3 < n2 ? dArray[n3] : 0.0;
            this.patx[n3] = (double)n3 / ((double)n - 1.0);
            ++n3;
        }
        this.paty[n - 1] = 0.0;
        this.inPlot.setData(this.patx, this.paty);
        this.doFractal((int)this.recur);
    }

    public Fractal() {
        super(title);
    }

    public static void main(String[] stringArray) {
        new Fractal();
    }

    void doFractal(int n) {
        this.n = (int)Math.pow(this.patx.length - 1, n) + 1;
        this.x = new double[this.n];
        this.y = new double[this.n];
        this.y[0] = 0.0;
        this.x[0] = 0.0;
        this.n = 1;
        this.makePath(new double[]{0.0, 0.0}, new double[]{1.0, 0.0}, n);
        this.outPlot.setData(this.x, this.y);
    }

    void makePath(double[] dArray, double[] dArray2, int n) {
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        if (n == 0) {
            this.x[this.n] = dArray2[0];
            this.y[this.n++] = dArray2[1];
            if (this.n >= this.x.length) {
                --this.n;
            }
            return;
        }
        double d = dArray2[0] - dArray[0];
        double d2 = dArray2[1] - dArray[1];
        dArray3[0] = dArray[0];
        dArray3[1] = dArray[1];
        int n2 = 1;
        while (n2 < this.patx.length) {
            dArray4[0] = dArray[0] + d * this.patx[n2] - d2 * this.paty[n2];
            dArray4[1] = dArray[1] + d2 * this.patx[n2] + d * this.paty[n2];
            this.makePath(dArray3, dArray4, n - 1);
            dArray3[0] = dArray4[0];
            dArray3[1] = dArray4[1];
            ++n2;
        }
    }
}

