/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface.apps;

import java.awt.CardLayout;
import java.awt.Choice;
import java.awt.event.ActionListener;
import rvl.awt.IntPlot;
import rvl.awt.RVLayout;
import rvl.piface.PiChoice;
import rvl.piface.PiDotplot;
import rvl.piface.PiListener;
import rvl.piface.PiPanel;
import rvl.piface.Piface;
import rvl.piface.apps.AnovaGUI;
import rvl.stat.Stat;
import rvl.stat.anova.Factor;
import rvl.stat.anova.Model;
import rvl.stat.anova.Term;
import rvl.stat.dist.Normal;

public class AnovaHelper
extends Piface
implements PiListener,
ActionListener {
    private static String title = "ANOVA Effects Helper";
    public int sel;
    public int distn;
    public int fixedRange;
    public int adjust;
    private AnovaGUI agui;
    private Model model;
    private int termNo;
    private int modFacNo;
    private int[] facNo = new int[2];
    private PiChoice chooser;
    private PiDotplot dotplot;
    private IntPlot plot;
    private CardLayout card;
    private PiPanel cardPanel;
    private String[] facName;
    private boolean MEmode = true;

    public void beforeSetup() {
        this.optMenu.remove(0);
    }

    public void gui() {
        this.choice("sel", "Effect", new String[]{"~"}, 0);
        this.chooser = (PiChoice)this.getComponent("sel");
        this.beginSubpanel(1);
        this.card = new CardLayout();
        this.cardPanel = this.panel;
        this.cardPanel.setLayout(this.card);
        this.panel = new PiPanel(new RVLayout(1, true, true));
        this.dotplot = this.dotplot("dotplot_changed", "Pattern of means", new double[]{-1.0, 1.0});
        this.choice("distn", "Distribution", new String[]{"(general)", "min SD", "normal", "uniform", "max SD"}, 1);
        this.choice("fixedRange", "Dist. option", new String[]{"Fixed SD", "Fixed Range"}, 1);
        this.cardPanel.add("MEPanel", this.panel);
        this.panel = new PiPanel(new RVLayout(1, true, true));
        this.cardPanel.add("2wayPanel", this.panel);
        this.panel.setStretchable(true);
        this.facName = new String[]{"", ""};
        double[] dArray = new double[]{1.0, 2.0};
        double[] dArray2 = new double[]{-1.0, 1.0};
        double[] dArray3 = new double[]{1.0, -1.0};
        double[][] dArrayArray = new double[][]{dArray2, dArray3};
        this.plot = new IntPlot(dArray, (double[][])dArrayArray);
        this.component("plot_changed", this.plot);
        this.plot.setConstraints(true, false);
        this.plot.setLineMode(true);
        this.plot.setDotMode(true);
        this.plot.setTickMode(false, true);
        this.plot.setTitle(">(Drag dots to modify)");
        this.labelAxes();
        this.beginSubpanel(2);
        this.checkbox("adjust", "Remove main effects", 1);
        this.button("swapFac", "Switch factors");
        this.endSubpanel();
        this.panel = this.cardPanel;
        this.endSubpanel();
    }

    public void afterSetup() {
        this.setupFixedFactors();
        this.optMenu.remove(0);
    }

    public void click() {
    }

    public void showMEs() {
        this.card.show(this.cardPanel, "MEPanel");
    }

    public void show2way() {
        this.card.show(this.cardPanel, "2wayPanel");
    }

    private void labelAxes() {
        this.plot.setAxisLabels(new String[]{"Levels of " + this.facName[0], ">Profiles: " + this.facName[1]}, new String[]{"Response"});
    }

    public void adjustMEs(boolean bl) {
        int n;
        int n2;
        double[][] dArray = this.plot.getYData();
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        double d = 0.0;
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n4];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = 0.0;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            dArray3[n2] = 0.0;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                int n5 = n2;
                dArray2[n5] = dArray2[n5] + dArray[n2][n] / (double)n4;
                int n6 = n;
                dArray3[n6] = dArray3[n6] + dArray[n2][n] / (double)n3;
                d += dArray[n2][n] / (double)n3 / (double)n4;
            }
        }
        double[][] dArray4 = dArray;
        if (!bl) {
            dArray4 = new double[n3][n4];
        }
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n4; ++i) {
                dArray4[n][i] = dArray[n][i] - dArray2[n] - dArray3[i] + d;
            }
        }
        if (bl) {
            this.plot.setYData(dArray4);
        }
        this.agui.effSD[this.termNo] = this.sd2(dArray4);
        String string = "effSD[" + this.termNo + "]";
        this.agui.callMethodFor(string);
        this.agui.updateVars();
        this.agui.notifyListeners(string, this);
    }

    public void plot_changed() {
        this.adjustMEs(this.adjust == 1);
    }

    public void adjust_changed() {
        this.adjustMEs(this.adjust == 1);
    }

    public void swapFac() {
        String string = this.facName[0];
        this.facName[0] = this.facName[1];
        this.facName[1] = string;
        int n = this.facNo[0];
        this.facNo[0] = this.facNo[1];
        this.facNo[1] = n;
        this.labelAxes();
        double[][] dArray = this.plot.getYData();
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        double[][] dArray2 = new double[n3][n2];
        double[] dArray3 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray3[i] = i;
            for (int j = 0; j < n3; ++j) {
                dArray2[j][i] = dArray[i][j];
            }
        }
        this.plot.setData(dArray3, dArray2);
    }

    public void sel_changed() {
        this.termNo = -1;
        String string = this.chooser.getChoice().getItem(this.sel);
        for (int i = 0; i < this.model.nTerm(); ++i) {
            if (!this.model.getTerm(i).getName().equals(string)) continue;
            this.termNo = i;
        }
        Term term = this.model.getTerm(this.termNo);
        if (term.order() == 2) {
            this.MEmode = false;
            this.modFacNo = -1;
            Factor[] factorArray = term.getFactors();
            this.facName[1] = factorArray[0].getName();
            this.facName[0] = factorArray[1].getName();
            for (int i = 0; i < this.model.nFac(); ++i) {
                String string2 = this.model.getFac(i).getName();
                if (string2.equals(this.facName[0])) {
                    this.facNo[0] = i;
                }
                if (!string2.equals(this.facName[1])) continue;
                this.facNo[1] = i;
            }
            this.show2way();
            this.setupIntPlot(factorArray);
        } else {
            int n;
            this.MEmode = true;
            this.showMEs();
            for (n = 0; n < this.model.nFac(); ++n) {
                if (!this.model.getFac(n).getName().equals(string)) continue;
                this.modFacNo = n;
            }
            n = this.fixedRange;
            this.fixedRange = 0;
            this.reviseDotplot(true);
            this.fixedRange = n;
        }
    }

    public double[] linCon(int n) {
        double[] dArray = new double[n];
        double d = 0.5 * (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            dArray[i] = (double)i - d;
        }
        return dArray;
    }

    public void distn_changed() {
        if (this.distn != 0) {
            this.revisePatternDotplot((int)(this.agui.n[this.modFacNo] + 0.05), false);
        }
    }

    public void fixedRange_changed() {
        Choice choice = ((PiChoice)this.getComponent("distn")).getChoice();
        int n = choice.getSelectedIndex();
        choice.remove(4);
        choice.remove(1);
        if (this.fixedRange == 0) {
            choice.insert("max range", 1);
            choice.insert("min range", 4);
        } else {
            choice.insert("min SD", 1);
            choice.insert("max SD", 4);
        }
        choice.select(n);
    }

    private void setupIntPlot(Factor[] factorArray) {
        int n = factorArray[0].getLevels();
        int n2 = factorArray[1].getLevels();
        double[] dArray = new double[n2];
        double[][] dArray2 = new double[n][n2];
        double[] dArray3 = this.linCon(n);
        double[] dArray4 = this.linCon(n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[j] = j;
                dArray2[i][j] = dArray3[i] * dArray4[j];
            }
        }
        this.labelAxes();
        this.plot.setData(dArray, dArray2, false);
        this.reviseIntPlotSD(dArray2);
    }

    private void reviseIntPlotSD(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double d = this.agui.effSD[this.termNo] / this.sd2(dArray);
        for (int i = 0; i < n; ++i) {
            int n3 = 0;
            while (n3 < n2) {
                double[] dArray2 = dArray[i];
                int n4 = n3++;
                dArray2[n4] = dArray2[n4] * d;
            }
        }
        this.plot.setYData(dArray);
    }

    private void reviseIntPlotSD() {
        this.reviseIntPlotSD(this.plot.getYData());
    }

    private void reviseIntPlotN(String string) {
        int n;
        Object object;
        int n2;
        int n3;
        int n4;
        int n5;
        double[][] dArray;
        if (string.equals("n[" + this.facNo[0] + "]")) {
            dArray = this.plot.getYData();
            n5 = (int)(this.agui.n[this.facNo[0]] + 0.05);
            n4 = dArray.length;
            n3 = dArray[0].length;
            n2 = Math.min(n3, n5);
            object = new double[n4][n5];
            double[] dArray2 = new double[n5];
            for (n = 0; n < n4; ++n) {
                int n6;
                for (n6 = 0; n6 < n2; ++n6) {
                    object[n][n6] = dArray[n][n6];
                }
                for (n6 = n2; n6 < n5; ++n6) {
                    object[n][n6] = 0.0;
                }
            }
            for (n = 0; n < n5; ++n) {
                dArray2[n] = n;
            }
            this.plot.setData(dArray2, (double[][])object);
            this.adjustMEs(this.adjust == 1);
        }
        if (string.equals("n[" + this.facNo[1] + "]")) {
            int n7;
            dArray = this.plot.getYData();
            n5 = (int)(this.agui.n[this.facNo[1]] + 0.05);
            n4 = dArray.length;
            n3 = dArray[0].length;
            n2 = Math.min(n4, n5);
            object = new double[n5][];
            for (n7 = 0; n7 < n2; ++n7) {
                object[n7] = dArray[n7];
            }
            for (n7 = n2; n7 < n5; ++n7) {
                object[n7] = new double[n3];
                for (n = 0; n < n3; ++n) {
                    object[n7][n] = 0.0;
                }
            }
            this.plot.setYData((double[][])object);
            this.adjustMEs(this.adjust == 1);
        }
    }

    private double sd2(double[][] dArray) {
        double d = 0.0;
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                d += dArray[i][j] * dArray[i][j];
            }
        }
        return AnovaHelper.sqrt(d / (double)(n - 1) / (double)(n2 - 1));
    }

    private void reviseDotplot(boolean bl) {
        int n = (int)(this.agui.n[this.modFacNo] + 0.05);
        if (this.distn == 0) {
            this.reviseGeneralDotplot(n, bl);
        } else {
            this.revisePatternDotplot(n, bl);
        }
    }

    private void reviseGeneralDotplot(int n, boolean bl) {
        int n2;
        double[] dArray = this.dotplot.getValue();
        double[] dArray2 = new double[n];
        double[] dArray3 = Stat.meanSD(dArray);
        if (dArray3[1] == 0.0) {
            dArray[0] = dArray[0] - dArray3[0];
            int n3 = dArray.length - 1;
            dArray[n3] = dArray[n3] + dArray3[0];
        }
        for (n2 = 1; n2 < n - 1; ++n2) {
            dArray2[n2] = dArray3[0];
        }
        for (n2 = 0; n2 < Math.min(n, dArray.length) / 2; ++n2) {
            dArray2[n2] = dArray[n2];
            dArray2[n - n2 - 1] = dArray[dArray.length - n2 - 1];
        }
        this.scaleAndDisplay(dArray2, false);
    }

    private void revisePatternDotplot(int n, boolean bl) {
        double[] dArray = new double[n];
        switch (this.distn) {
            case 1: {
                dArray[0] = -1.0;
                dArray[n - 1] = 1.0;
                for (int i = 1; i < n - 1; ++i) {
                    dArray[i] = 0.0;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = Normal.quantile(((double)i + 0.5) / (double)n);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = i;
                }
                break;
            }
            case 4: {
                for (int i = 0; i < 1 + n / 2; ++i) {
                    dArray[i] = -1.0;
                    dArray[n - i - 1] = 1.0;
                }
                break;
            }
        }
        this.scaleAndDisplay(dArray, !bl && this.fixedRange == 1);
    }

    private void scaleAndDisplay(double[] dArray, boolean bl) {
        double d;
        double d2;
        double d3;
        double d4;
        double[] dArray2 = this.dotplot.getValue();
        int n = dArray.length;
        if (bl) {
            d4 = dArray[0];
            d3 = dArray[n - 1] - dArray[0];
            d2 = dArray2[0];
            d = dArray2[dArray2.length - 1] - dArray2[0];
        } else {
            double[] dArray3 = Stat.meanSD(dArray);
            d4 = dArray3[0];
            d3 = dArray3[1];
            d2 = Stat.mean(dArray2);
            d = this.agui.effSD[this.termNo];
        }
        double d5 = d / d3;
        for (int i = 0; i < n; ++i) {
            dArray[i] = d2 + d5 * (dArray[i] - d4);
        }
        this.dotplot.setValue(dArray);
        this.dotplot.repaint();
        this.updateSD();
    }

    private void updateSD() {
        this.agui.effSD[this.termNo] = Stat.sd(this.dotplot.getValue());
        String string = "effSD[" + this.termNo + "]";
        this.agui.callMethodFor(string);
        this.agui.updateVars();
        this.agui.notifyListeners(string, this);
    }

    private void setupFixedFactors() {
        Choice choice = this.chooser.getChoice();
        String string = choice.getItem(this.sel);
        choice.removeAll();
        this.sel = 0;
        for (int i = 0; i < this.model.nTerm(); ++i) {
            Term term = this.model.getTerm(i);
            if (term.order() > 2 || term.isRandom()) continue;
            String string2 = term.getName();
            if (string2.equals(string)) {
                this.sel = choice.getItemCount();
            }
            choice.add(string2);
        }
        if (choice.getItemCount() == 0) {
            choice.add("(disabled)");
            this.dotplot.setVisible(false);
        } else {
            this.dotplot.setVisible(true);
            this.sel_changed();
            choice.select(this.sel);
        }
    }

    public void piAction(String string) {
        if (string.equals("effSD[" + this.termNo + "]") || string.equals("power[" + this.termNo + "]")) {
            if (this.MEmode) {
                this.reviseDotplot(true);
            } else {
                this.reviseIntPlotSD();
            }
        } else if (string.startsWith("n[")) {
            if (!this.MEmode) {
                this.reviseIntPlotN(string);
            } else if (string.equals("n[" + this.modFacNo + "]")) {
                this.reviseDotplot(true);
            }
        } else if (string.startsWith("random")) {
            this.setupFixedFactors();
        }
    }

    public void dotplot_changed() {
        if (this.dotplot.getActionCommand().equals("Dotplot:Shift")) {
            return;
        }
        this.distn = 0;
        this.updateSD();
    }

    public void close() {
        this.agui.helper = null;
        this.agui.removePiListener(this);
        this.dispose();
    }

    public AnovaHelper(AnovaGUI anovaGUI) {
        super(title, false);
        this.agui = anovaGUI;
        this.model = anovaGUI.getModel();
        anovaGUI.addPiListener(this);
        this.build();
    }

    public static void main(String[] stringArray) {
        AnovaGUI anovaGUI = new AnovaGUI("Test of AnovaHelper", "row | col | trt", 10, "row 5 col 3 trt 4", "");
        anovaGUI.linkHelper();
    }
}

