/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;

public class PiImage
extends Component {
    private Image image = null;
    private int w;
    private int h;

    public PiImage(String string, Class clazz) {
        this(string, clazz, 0, 0);
    }

    public PiImage(String string, Class clazz, int n, int n2) {
        try {
            InputStream inputStream = clazz.getResourceAsStream(string);
            int n3 = inputStream.available();
            byte[] byArray = new byte[n3];
            for (int i = 0; i < n3; i += inputStream.read(byArray, i, n3 - i)) {
            }
            inputStream.close();
            this.image = Toolkit.getDefaultToolkit().createImage(byArray, 0, n3);
            if (n * n2 > 0) {
                this.w = n;
                this.h = n2;
            } else {
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(this.image, 0);
                mediaTracker.waitForID(0);
                this.w = this.image.getWidth(this);
                this.h = this.image.getHeight(this);
            }
        }
        catch (IOException iOException) {
            System.err.println("PiImage(\"" + string + "\",Class)\n" + iOException.toString());
        }
        catch (InterruptedException interruptedException) {
            System.err.println("PiImage(\"" + string + "\",Class)\n" + interruptedException.toString());
        }
    }

    public void paint(Graphics graphics) {
        if (this.image != null) {
            Dimension dimension = this.getPreferredSize();
            Dimension dimension2 = this.getSize();
            int n = (dimension2.width - dimension.width) / 2;
            int n2 = (dimension2.height - dimension.height) / 2;
            graphics.drawImage(this.image, n, n2, this);
        }
    }

    public Dimension getPreferredSize() {
        if (this.image == null) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.w, this.h);
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }
}

