/*
 * Decompiled with CFR 0.152.
 */
package rvl.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Polygon;

public class ArrowButton
extends Canvas {
    private boolean upward;
    private boolean incFlag = false;
    private Polygon arrow;
    private int wid;
    private int ht;

    public ArrowButton(boolean bl, int n, int n2) {
        this.upward = bl;
        this.wid = n;
        this.ht = n2;
        this.resize(n, n2);
    }

    public Dimension preferredSize() {
        return new Dimension(this.wid, this.ht);
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
        int n3 = this.size().width;
        int n4 = this.size().height;
        int n5 = n3 / 2;
        int n6 = n3 / 4;
        int n7 = n4 / 4;
        this.arrow = new Polygon();
        if (this.upward) {
            this.arrow.addPoint(n6, n4 - n7);
            this.arrow.addPoint(n5, n7);
            this.arrow.addPoint(n3 - n6, n4 - n7);
        } else {
            this.arrow.addPoint(n6, n7);
            this.arrow.addPoint(n5, n4 - n7);
            this.arrow.addPoint(n3 - n6, n7);
        }
    }

    public void draw(Graphics graphics, boolean bl) {
        int n = this.size().width;
        int n2 = this.size().height;
        graphics.setColor(Color.lightGray);
        graphics.fill3DRect(0, 0, n, n2, bl);
        graphics.setColor(Color.black);
        graphics.fillPolygon(this.arrow);
    }

    public void paint(Graphics graphics) {
        this.draw(graphics, true);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.draw(this.getGraphics(), false);
        this.incFlag = true;
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.draw(this.getGraphics(), true);
        this.incFlag = false;
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.draw(this.getGraphics(), true);
        if (this.incFlag) {
            this.deliverEvent(new Event(this, 1001, new String(this.upward ? "up" : "down")));
        }
        this.incFlag = false;
        return true;
    }
}

