(* Parser/lexer generation

   cd H:\Desktop\Fun
   bin\fslex --unicode FunLex.fsl
   bin\fsyacc --module FunPar FunPar.fsy
*)

// Windows
   #r "H:\Desktop\Fun\\bin\FsLexYacc.Runtime.dll"
   #load "H:\Desktop\Fun\Absyn.fs" 
   #load "H:\Desktop\Fun\FunPar.fs"
   #load "H:\Desktop\Fun\FunLex.fs" 
   #load "H:\Desktop\Fun\Parse.fs" 
   #load "H:\Desktop\Fun\Fun.fs"


// Mac Os
   #r "/Users/tinelli/Desktop/Fun/bin/FsLexYacc.Runtime.dll"
   #load "/Users/tinelli/Desktop/Fun/Absyn.fs" 
   #load "/Users/tinelli/Desktop/Fun/FunPar.fs"
   #load "/Users/tinelli/Desktop/Fun/FunLex.fs" 
   #load "/Users/tinelli/Desktop/Fun/Parse.fs" 
   #load "/Users/tinelli/Desktop/Fun/Fun.fs"


open Absyn

let fromString = Parse.fromString
let eval = Fun.eval
let run = Fun.run



(* Examples in abstract syntax *)

(*
  let g y = y + 1
  in
    g 6
  end
*)
let e1 = Letfun ("g", "y", Prim ("+", Var "y", CstI 1), 
                 Call (Var "g", CstI 6))


run e1

let e = fromString "
  let y = 4 in
  let f x = if x = 0 then 0 else x + f (x-1) in 
    f y 
  end
  end"


let e = fromString "x + y *z"

run e


(*
eval Letfun ("g", "y", Prim ("+", Var "y", CstI 1), Call (Var "f", CstI 6)) [] ---> 
eval Call (Var "f", CstI 6) [(f, Closure("g", "y", Prim ("+", Var "y", CstI 1), []))] --->
eval Prim ("+", Var "y", CstI 1) [("y", CstI 6); (f, Closure("g", "y", Prim ("+", Var "y", CstI 1), []))]
6 + 1 ---> 7 
*)

(*
  let f x = x + 1 in
    let g x = 2 * x in
      (f 2) + (g 5) 
    end
  end
*)
let e2 = Letfun ("f", "x", Prim ("+", Var "x", CstI 1), 
                 Letfun ("g", "x", Prim ("*", CstI 2, Var "x"),
                         Prim ("+", Call (Var "f", CstI 2),
                                    Call (Var "g", CstI 5))))

run e2


(* Example: factorial *)

(* 
  let fac x = 
    if x = 0 then 1 
    else x * fact (x - 1) 
  in 
    fact n 
  end
*)

let e3 = Letfun ("fac", "x",
                 If (Prim ("=", Var "x", CstI 0),
                     CstI 1,
                     Prim ("*", Var "x", 
                           Call (Var "fac", 
                                 Prim ("-", Var "x", CstI 1)))),
                 Call(Var "fac", Var "n"))

eval e3 [("n", Fun.Int 4)]






(* Example: static scope (result 14) or dynamic scope (result 25) *)

let e4 =
    Let("y", CstI 11,
        Letfun("f", "x", Prim("+", Var "x", Var "y"),
               Let("y", CstI 22, Call(Var "f", CstI 3))));;

run e4



(* Example: two function definitions: a comparison and Fibonacci *)

let e5 = 
    Letfun("ge2", "x", Prim("<", CstI 1, Var "x"),
           Letfun("fib", "n",
                  If(Call(Var "ge2", Var "n"),
                     Prim("+",
                          Call(Var "fib", Prim("-", Var "n", CstI 1)),
                          Call(Var "fib", Prim("-", Var "n", CstI 2))),
                     CstI 1), Call(Var "fib", CstI 25)));;
                     
run e5



(* Examples in concrete syntax *)

let ex1 = fromString "5+7"

let ex2 = fromString "let f x = x + 7 in f 2 end"

let ex3 = fromString "let f1 x = x + 1 in f1 12 end"

(* Example: factorial *)

let ex4 = fromString "
  let fac x = 
    if x=0 then 1 else x * fac(x - 1)
  in 
    fac n 
  end"

eval ex4 [("n", Fun.Int 5)]


(* Example: static scope (result 14) or dynamic scope (result 25) *)

let ex5 = fromString "
  let y = 11 in 
    let f x = x + y in 
      let y = 22 in 
        f 3 
      end 
    end
  end"

run ex5


let ex6 = fromString "
  let f x = 
    let g y = 2 * y in
      (g x) + 1 
    end
  in
    f 3
  end
"

let ex7 = fromString "
  let f x =
    x + 1 
  in
    let g y = 2 * y in
      (g (f 4)) + 1 
    end
  end
"

run ex7

(* Example: two function definitions: a comparison and Fibonacci *)

let ex5 = fromString "
  let inc x = x + 1 in 
    let fib n = 
        let ge2 x = 1 < x in 
          if ge2 n then fib (n-1) + fib (n-2) else 1 
        
     in 
      fib 25 
    end
  end"
