/*
   22c22: Object Oriented Software Development
   Fall 2011
   The University of Iowa
   
   Instructor: Cesare Tinelli
*/

/* Examples of ScalaTest suites 

   Adapted from ScalaTest manual

*/

import org.scalatest._

// sample code to be tested
object Misc {

// given an integer x and a list l of integers
// remove(x, l)
// ``removes'' all the occurrences of x from l, that is,
// returns a list containing (in the same order) all and only 
// the elements of l that differ from x.

	def remove(x: Int, l: List[Int]): List[Int] = l match {
		case Nil => Nil
		case h::t => if (x == h) remove(x, t) else h::remove(x, t)
	}

// given an integer array a and an integer i in a's range,
// find the posiiton of the mimimum element among those 
// between position i and the end.
	def min(a:Array[Int], i:Int) = {  
		require(0 <= i && i < a.size)
		
		var m = i
		for (j <- i to a.length-1)
			if (a(m) > a(j))  m = j
		m
	}

// given an integer array a,
// sort(a) sorts the array in place in non-decreasing order.
	def sort(a:Array[Int]) {
		def swap(i:Int, j:Int) {
			var t = a(i); a(i) = a(j); a(j) = t
		}
		for (i <- 0 to a.length - 1)  swap(i, min(a,i))
		} 
	}




class ExampleSuite0 extends FunSuite {
 import Misc._
 
	test("removed is invoked on an empty list") {
		assert(remove(3,Nil) === Nil)
	}

	test("remove x is invoked on a list not containing x") {
		val l = List(1,2,4)
		assert(remove(3, l) === l)
	}
	
	test("remove x is invoked on a list containing one occurrence of x") {
		assert(remove(3, List(1,2,3,4)) === List(1,2,4))
	}
	
	
	test("remove x is invoked on a list containing multiple occurrences of x") {
		assert(remove(3, List(1,2,3,4,3,5)) === List(1,4,5))
	}

	test("expect: remove x is invoked on a list containing multiple occurrences of x") {
		expect(List(1,2,4,5)) {
			remove(3, List(1,2,3,4,3,5))
		}
	}

	test("min is invoked with i out of the array range") {
		intercept[IllegalArgumentException] {
			min(Array(4,2,8), 5) === 7
		}
	}

	test("min is invoked on a non-empty array with index in range") {
		assert(min(Array(4,2,3,8), 0) === 1)
		assert(min(Array(4,1,3,8), 2) === 2)
  }

	
}


class ExampleSuite1 extends FunSuite {
	import scala.collection.mutable.Stack
 
	test("pop is invoked on a non-empty stack") {
 
    val stack = new Stack[Int]
    stack.push(1)
    stack.push(2)
    val oldSize = stack.size
    val result = stack.pop()
    assert(result === 2)
    assert(stack.size === oldSize - 1)
  }
 
  test("pop is invoked on an empty stack") {
 
    val emptyStack = new Stack[Int]
    intercept[NoSuchElementException] {
      emptyStack.pop()
    }
    assert(emptyStack.isEmpty)
  }
}


class ExampleSuite2 extends FunSuite with BeforeAndAfter {
  import scala.collection.mutable.ListBuffer
  
  // Fixtures as reassignable variables and mutable objects
  var sb: StringBuilder = _
  val lb = new ListBuffer[String]

  before {
    sb = new StringBuilder("ScalaTest is ")
    lb.clear()
  }

  test("Testing easy") {
    sb.append("easy!")
    assert(sb.toString === "ScalaTest is easy!")
    assert(lb.isEmpty)
    lb += "sweet"
  }

  test("Testing fun") {
    sb.append("fun!")
    assert(sb.toString === "ScalaTest is fun!")
    assert(lb.isEmpty)
  }
}







object Main extends App {
	val e0 = new ExampleSuite0
	val e1 = new ExampleSuite1
	val e2 = new ExampleSuite2
	e0.execute()
	e1.execute()
	e2.execute()
}